"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnlinkDashboard = UnlinkDashboard;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../../../shared/links/url_helpers");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function UnlinkDashboard({
  currentDashboard,
  defaultDashboard,
  onRefresh
}) {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    core: {
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const onConfirm = (0, _react.useCallback)(async function () {
    try {
      await (0, _create_call_apm_api.callApmApi)('DELETE /internal/apm/custom-dashboard', {
        params: {
          query: {
            customDashboardId: currentDashboard.id
          }
        },
        signal: null
      });
      history.push({
        ...history.location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _url_helpers.toQuery)(location.search),
          dashboardId: defaultDashboard.dashboardSavedObjectId
        })
      });
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkSuccess.toast.title', {
          defaultMessage: 'Unlinked "{dashboardName}" dashboard',
          values: {
            dashboardName: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.title
          }
        })
      });
      onRefresh();
    } catch (error) {
      console.error(error);
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkFailure.toast.title', {
          defaultMessage: 'Error while unlinking "{dashboardName}" dashboard',
          values: {
            dashboardName: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.title
          }
        }),
        text: error.body.message
      });
    }
    setIsModalVisible(!isModalVisible);
  }, [currentDashboard, notifications.toasts, setIsModalVisible, onRefresh, isModalVisible, history, defaultDashboard]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    size: "s",
    iconType: 'unlink',
    "data-test-subj": "apmUnLinkServiceDashboardMenu",
    onClick: () => setIsModalVisible(true)
  }, _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkEmptyButtonLabel', {
    defaultMessage: 'Unlink dashboard'
  })), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkEmptyButtonLabel.confirm.title', {
      defaultMessage: 'Unlink Dashboard'
    }),
    onCancel: () => setIsModalVisible(false),
    onConfirm: onConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkEmptyButtonLabel.confirm.button', {
      defaultMessage: 'Unlink dashboard'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceDashboards.unlinkEmptyButtonLabel.confirm.body', {
    defaultMessage: 'You are about to unlink the dashboard from the service context'
  }))));
}