"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGoAgentInstructions = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _agent_config_instructions = require("../agent_config_instructions");
var _instruction_variants = require("../instruction_variants");
var _api_key_callout = require("./api_key_callout");
var _agent_status_instructions = require("../agent_status_instructions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGoAgentInstructions = commonOptions => {
  const {
    baseUrl,
    apmServerUrl,
    apiKeyDetails,
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  } = commonOptions;
  const codeBlock = `\
import (
  "net/http"

  "go.elastic.co/apm/module/apmhttp"
)

func main() {
  mux := http.NewServeMux()
  ...
  http.ListenAndServe(":8080", apmhttp.Wrap(mux))
}
`;
  return [{
    title: _i18n.i18n.translate('xpack.apm.onboarding.go.install.title', {
      defaultMessage: 'Install the APM agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.go.install.textPre', {
      defaultMessage: 'Install the APM agent packages for Go.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "bash",
      isCopyable: true
    }, "go get go.elastic.co/apm"))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.go.configure.title', {
      defaultMessage: 'Configure the agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.go.configure.textPre', {
      defaultMessage: 'Agents are libraries that run inside of your application process. \
APM services are created programmatically based on the executable \
file name, or the `ELASTIC_APM_SERVICE_NAME` environment variable.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), ((apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout) || (apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key_callout.ApiKeyCallout, {
      isError: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout,
      isSuccess: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout,
      errorMessage: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.errorMessage
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
      variantId: _instruction_variants.INSTRUCTION_VARIANT.GO,
      apmServerUrl: apmServerUrl,
      apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey,
      createApiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createAgentKey,
      createApiKeyLoading: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createApiKeyLoading
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.go.configure.textPost', {
      defaultMessage: 'See the [documentation]({documentationLink}) for advanced configuration.',
      values: {
        documentationLink: `${baseUrl}guide/en/apm/agent/go/current/configuration.html`
      }
    })))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.go.goClient.title', {
      defaultMessage: 'Instrument your application'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.go.instrument.textPre', {
      defaultMessage: 'Instrument your Go application by using one of the provided instrumentation modules or \
by using the tracer API directly.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "go",
      isCopyable: true
    }, codeBlock), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.go.instrument.textPost', {
      defaultMessage: 'See the [documentation]({documentationLink}) for a detailed \
guide to instrumenting Go source code.',
      values: {
        documentationLink: `${baseUrl}guide/en/apm/agent/go/current/instrumenting-source.html`
      }
    })))
  }, (0, _agent_status_instructions.agentStatusCheckInstruction)({
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  })];
};
exports.createGoAgentInstructions = createGoAgentInstructions;