"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardPanelMap = getDashboardPanelMap;
exports.hasDashboardFile = hasDashboardFile;
var _dashboard_catalog = require("./dashboards/dashboard_catalog");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hasDashboardFile(props) {
  return !!getDashboardFile(props);
}
function getDashboardFile({
  agentName
}) {
  const dashboardFile = agentName && _dashboard_catalog.AGENT_NAME_DASHBOARD_FILE_MAPPING[agentName];
  return dashboardFile;
}
async function getDashboardPanelMap(props, dataViewId) {
  const dashboardFile = getDashboardFile(props);
  const panelsRawObj = !!dashboardFile ? await (0, _dashboard_catalog.loadDashboardFile)(dashboardFile) : undefined;
  if (!dashboardFile || !panelsRawObj) {
    return undefined;
  }
  const panelsStr = panelsRawObj.attributes.panelsJSON.replaceAll('APM_STATIC_DATA_VIEW_ID', dataViewId);
  const panelsRawObjects = JSON.parse(panelsStr);
  return panelsRawObjects.reduce((acc, panel) => ({
    ...acc,
    [panel.gridData.i]: {
      type: panel.type,
      gridData: panel.gridData,
      explicitInput: {
        id: panel.panelIndex,
        ...panel.embeddableConfig,
        title: panel.title
      }
    }
  }), {});
}