"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.versionSchema = exports.throttledActionSchema = exports.rawAlertInstanceSchema = exports.metaSchema = exports.lastScheduledActionsSchema = exports.alertStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionSchema = _configSchema.schema.object({
  date: _configSchema.schema.string()
});
const throttledActionSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), actionSchema);
// TODO: Add schema by rule type for alert state
// https://github.com/elastic/kibana/issues/159344
exports.throttledActionSchema = throttledActionSchema;
const alertStateSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()));
// TODO: Add schema by rule type for rule state
// https://github.com/elastic/kibana/issues/159344
exports.alertStateSchema = alertStateSchema;
const ruleStateSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()));
const lastScheduledActionsSchema = _configSchema.schema.object({
  subgroup: _configSchema.schema.maybe(_configSchema.schema.string()),
  group: _configSchema.schema.string(),
  date: _configSchema.schema.string(),
  actions: _configSchema.schema.maybe(throttledActionSchema)
});
exports.lastScheduledActionsSchema = lastScheduledActionsSchema;
const metaSchema = _configSchema.schema.object({
  lastScheduledActions: _configSchema.schema.maybe(lastScheduledActionsSchema),
  // an array used to track changes in alert state, the order is based on the rule executions (oldest to most recent)
  // true - alert has changed from active/recovered
  // false - the status has remained either active or recovered
  flappingHistory: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.boolean())),
  // flapping flag that indicates whether the alert is flapping
  flapping: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  maintenanceWindowIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  pendingRecoveredCount: _configSchema.schema.maybe(_configSchema.schema.number()),
  uuid: _configSchema.schema.maybe(_configSchema.schema.string())
});
exports.metaSchema = metaSchema;
const rawAlertInstanceSchema = _configSchema.schema.object({
  meta: _configSchema.schema.maybe(metaSchema),
  state: _configSchema.schema.maybe(alertStateSchema)
});
exports.rawAlertInstanceSchema = rawAlertInstanceSchema;
const versionSchema = _configSchema.schema.object({
  alertTypeState: _configSchema.schema.maybe(ruleStateSchema),
  // tracks the active alerts
  alertInstances: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), rawAlertInstanceSchema)),
  // tracks the recovered alerts for flapping purposes
  alertRecoveredInstances: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), rawAlertInstanceSchema)),
  previousStartedAt: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  summaryActions: _configSchema.schema.maybe(throttledActionSchema)
});
exports.versionSchema = versionSchema;