"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkUntrackAlertRoute = void 0;
var _bulk_untrack = require("../../../../../common/routes/rule/apis/bulk_untrack");
var _transforms = require("./transforms");
var _lib = require("../../../../lib");
var _lib2 = require("../../../lib");
var _types = require("../../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkUntrackAlertRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/alerts/_bulk_untrack`,
    validate: {
      body: _bulk_untrack.bulkUntrackBodySchemaV1
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const body = req.body;
    try {
      await rulesClient.bulkUntrackAlerts((0, _transforms.transformRequestBodyToApplicationV1)(body));
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.bulkUntrackAlertRoute = bulkUntrackAlertRoute;