"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeRange = getTimeRange;
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTimeRange(logger, queryDelaySettings, window) {
  let timeWindow = 0;
  if (window) {
    try {
      timeWindow = (0, _common.parseDuration)(window);
    } catch (err) {
      throw new Error(_i18n.i18n.translate('xpack.alerting.invalidWindowSizeErrorMessage', {
        defaultMessage: 'Invalid format for windowSize: "{window}"',
        values: {
          window
        }
      }));
    }
  }
  logger.debug(`Adjusting rule query time range by ${queryDelaySettings.delay} seconds`);
  const queryDelay = queryDelaySettings.delay * 1000;
  const date = Date.now();
  const dateStart = new Date(date - (timeWindow + queryDelay)).toISOString();
  const dateEnd = new Date(date - queryDelay).toISOString();
  return {
    dateStart,
    dateEnd
  };
}