"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleNotifyWhenAttributes = exports.ruleLastRunOutcomeValuesAttributes = exports.ruleExecutionStatusWarningReasonAttributes = exports.ruleExecutionStatusValuesAttributes = exports.ruleExecutionStatusErrorReasonAttributes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleNotifyWhenAttributes = {
  CHANGE: 'onActionGroupChange',
  ACTIVE: 'onActiveAlert',
  THROTTLE: 'onThrottleInterval'
};
exports.ruleNotifyWhenAttributes = ruleNotifyWhenAttributes;
const ruleLastRunOutcomeValuesAttributes = {
  SUCCEEDED: 'succeeded',
  WARNING: 'warning',
  FAILED: 'failed'
};
exports.ruleLastRunOutcomeValuesAttributes = ruleLastRunOutcomeValuesAttributes;
const ruleExecutionStatusValuesAttributes = {
  OK: 'ok',
  ACTIVE: 'active',
  ERROR: 'error',
  WARNING: 'warning',
  PENDING: 'pending',
  UNKNOWN: 'unknown'
};
exports.ruleExecutionStatusValuesAttributes = ruleExecutionStatusValuesAttributes;
const ruleExecutionStatusErrorReasonAttributes = {
  READ: 'read',
  DECRYPT: 'decrypt',
  EXECUTE: 'execute',
  UNKNOWN: 'unknown',
  LICENSE: 'license',
  TIMEOUT: 'timeout',
  DISABLED: 'disabled',
  VALIDATE: 'validate'
};
exports.ruleExecutionStatusErrorReasonAttributes = ruleExecutionStatusErrorReasonAttributes;
const ruleExecutionStatusWarningReasonAttributes = {
  MAX_EXECUTABLE_ACTIONS: 'maxExecutableActions',
  MAX_ALERTS: 'maxAlerts',
  MAX_QUEUED_ACTIONS: 'maxQueuedActions'
};
exports.ruleExecutionStatusWarningReasonAttributes = ruleExecutionStatusWarningReasonAttributes;