"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsFilterQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsFilterQuerySchema = _configSchema.schema.object({
  kql: _configSchema.schema.string(),
  filters: _configSchema.schema.arrayOf(_configSchema.schema.object({
    query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
    meta: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
    $state: _configSchema.schema.maybe(_configSchema.schema.object({
      store: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.filterStateStore.APP_STATE), _configSchema.schema.literal(_constants.filterStateStore.GLOBAL_STATE)])
    }))
  })),
  dsl: _configSchema.schema.maybe(_configSchema.schema.string())
});
exports.alertsFilterQuerySchema = alertsFilterQuerySchema;