"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMaintenanceWindow = createMaintenanceWindow;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRequest = ({
  rRule,
  categoryIds,
  scopedQuery,
  ...res
}) => ({
  ...res,
  r_rule: rRule,
  category_ids: categoryIds,
  scoped_query: scopedQuery
});
const rewriteBodyRes = ({
  r_rule: rRule,
  category_ids: categoryIds,
  scoped_query: scopedQuery,
  ...rest
}) => ({
  ...rest,
  rRule,
  categoryIds,
  scopedQuery
});
async function createMaintenanceWindow({
  http,
  maintenanceWindow
}) {
  const res = await http.post(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/rules/maintenance_window`, {
    body: JSON.stringify(rewriteBodyRequest(maintenanceWindow))
  });
  return rewriteBodyRes(res);
}