"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoute = void 0;
var _schema_v = require("../../../common/api/log_rate_analysis/schema_v1");
var _schema_v2 = require("../../../common/api/log_rate_analysis/schema_v2");
var _api = require("../../../common/api");
var _route_handler_factory = require("./route_handler_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * `defineRoute` is called in the root `plugin.ts` to set up the API route
 * for log pattern analysis. Its purpose is to take care of the route setup
 * and versioning only. `routeHandlerFactory` is used to take care of
 * the actual route logic.
 */
const defineRoute = (router, license, logger, coreStart, usageCounter) => {
  router.versioned.post({
    path: _api.AIOPS_API_ENDPOINT.LOG_RATE_ANALYSIS,
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _schema_v.aiopsLogRateAnalysisSchemaV1
      }
    }
  }, (0, _route_handler_factory.routeHandlerFactory)('1', license, logger, coreStart, usageCounter)).addVersion({
    version: '2',
    validate: {
      request: {
        body: _schema_v2.aiopsLogRateAnalysisSchemaV2
      }
    }
  }, (0, _route_handler_factory.routeHandlerFactory)('2', license, logger, coreStart, usageCounter));
};
exports.defineRoute = defineRoute;