"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiopsPlugin = void 0;
var _rxjs = require("rxjs");
var _embeddable_change_point_chart_component = require("./embeddable/embeddable_change_point_chart_component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class AiopsPlugin {
  setup(core, {
    embeddable,
    cases,
    licensing,
    uiActions
  }) {
    Promise.all([(0, _rxjs.firstValueFrom)(licensing.license$), Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/register_embeddable'))), Promise.resolve().then(() => _interopRequireWildcard(require('./ui_actions'))), Promise.resolve().then(() => _interopRequireWildcard(require('./cases/register_change_point_charts_attachment'))), core.getStartServices()]).then(([license, {
      registerEmbeddable
    }, {
      registerAiopsUiActions
    }, {
      registerChangePointChartsAttachment
    }, [coreStart, pluginStart]]) => {
      if (license.hasAtLeast('platinum')) {
        if (embeddable) {
          registerEmbeddable(core, embeddable);
        }
        if (uiActions) {
          registerAiopsUiActions(uiActions, coreStart, pluginStart);
        }
        if (cases) {
          registerChangePointChartsAttachment(cases, coreStart, pluginStart);
        }
      }
    });
  }
  start(core, plugins) {
    return {
      EmbeddableChangePointChart: (0, _embeddable_change_point_chart_component.getEmbeddableChangePointChart)(core, plugins)
    };
  }
  stop() {}
}
exports.AiopsPlugin = AiopsPlugin;