"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAiopsAppContext = exports.AiopsAppContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * AIOps App Dependencies to be provided via React context.
 */

/**
 * React AIOps app dependency context.
 */
const AiopsAppContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * Custom hook to get AIOps app dependency context.
 */
exports.AiopsAppContext = AiopsAppContext;
const useAiopsAppContext = () => {
  const aiopsAppContext = (0, _react.useContext)(AiopsAppContext);

  // if `undefined`, throw an error
  if (aiopsAppContext === undefined) {
    throw new Error('useAiopsAppContext was used outside of its Provider');
  }
  return aiopsAppContext;
};
exports.useAiopsAppContext = useAiopsAppContext;