"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddableChangePointUserInput = resolveEmbeddableChangePointUserInput;
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _use_aiops_app_context = require("../hooks/use_aiops_app_context");
var _change_point_chart_initializer = require("./change_point_chart_initializer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveEmbeddableChangePointUserInput(coreStart, pluginStart, input) {
  const {
    overlays
  } = coreStart;
  return new Promise(async (resolve, reject) => {
    try {
      const modalSession = overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
        value: {
          ...coreStart,
          ...pluginStart
        }
      }, /*#__PURE__*/_react.default.createElement(_change_point_chart_initializer.ChangePointChartInitializer, {
        initialInput: input,
        onCreate: update => {
          modalSession.close();
          resolve(update);
        },
        onCancel: () => {
          modalSession.close();
          reject();
        }
      })), {
        theme: coreStart.theme,
        i18n: coreStart.i18n
      }));
    } catch (error) {
      reject(error);
    }
  });
}