"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerChangePointChartsAttachment = registerChangePointChartsAttachment;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../common/constants");
var _embeddable_change_point_chart_component = require("../embeddable/embeddable_change_point_chart_component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
function registerChangePointChartsAttachment(cases, coreStart, pluginStart) {
  const EmbeddableComponent = (0, _embeddable_change_point_chart_component.getEmbeddableChangePointChart)(coreStart, pluginStart);
  cases.attachmentFramework.registerPersistableState({
    id: _constants.CASES_ATTACHMENT_CHANGE_POINT_CHART,
    icon: 'machineLearningApp',
    displayName: _i18n.i18n.translate('xpack.aiops.changePointDetection.cases.attachmentName', {
      defaultMessage: 'Change point chart'
    }),
    getAttachmentViewObject: () => ({
      event: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.changePointDetection.cases.attachmentEvent",
        defaultMessage: "added change point chart"
      }),
      timelineAvatar: 'machineLearningApp',
      children: /*#__PURE__*/_react.default.lazy(async () => {
        const {
          initComponent
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./change_point_charts_attachment')));
        return {
          default: initComponent(pluginStart.fieldFormats, EmbeddableComponent)
        };
      })
    })
  });
}