"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildExtendedBaseFilterCriteria = buildExtendedBaseFilterCriteria;
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _get_category_query = require("../../../common/api/log_categorization/get_category_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO Consolidate with duplicate query utils in
// `x-pack/plugins/data_visualizer/common/utils/query_utils.ts`

/*
 * Contains utility functions for building and processing queries.
 */

// Builds the base filter criteria used in queries,
// adding criteria for the time range and an optional query.
function buildExtendedBaseFilterCriteria(timeFieldName, earliestMs, latestMs, query, selectedSignificantItem, includeSelectedSignificantItem = true, selectedGroup) {
  const filterCriteria = (0, _mlQueryUtils.buildBaseFilterCriteria)(timeFieldName, earliestMs, latestMs, query);
  const groupFilter = [];
  if (selectedGroup) {
    const allItems = selectedGroup.groupItemsSortedByUniqueness;
    for (const item of allItems) {
      const {
        fieldName,
        fieldValue,
        key,
        type,
        docCount
      } = item;
      if (type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.KEYWORD) {
        groupFilter.push({
          term: {
            [fieldName]: fieldValue
          }
        });
      } else {
        groupFilter.push((0, _get_category_query.getCategoryQuery)(fieldName, [{
          key,
          count: docCount,
          examples: []
        }]));
      }
    }
  }
  if (includeSelectedSignificantItem) {
    if (selectedSignificantItem) {
      if (selectedSignificantItem.type === 'keyword') {
        filterCriteria.push({
          term: {
            [selectedSignificantItem.fieldName]: selectedSignificantItem.fieldValue
          }
        });
      } else {
        filterCriteria.push((0, _get_category_query.getCategoryQuery)(selectedSignificantItem.fieldName, [{
          key: `${selectedSignificantItem.key}`,
          count: selectedSignificantItem.doc_count,
          examples: []
        }]));
      }
    } else if (selectedGroup) {
      filterCriteria.push(...groupFilter);
    }
  } else if (selectedSignificantItem && !includeSelectedSignificantItem) {
    if (selectedSignificantItem.type === 'keyword') {
      filterCriteria.push({
        bool: {
          must_not: [{
            term: {
              [selectedSignificantItem.fieldName]: selectedSignificantItem.fieldValue
            }
          }]
        }
      });
    } else {
      filterCriteria.push({
        bool: {
          must_not: [(0, _get_category_query.getCategoryQuery)(selectedSignificantItem.fieldName, [{
            key: `${selectedSignificantItem.key}`,
            count: selectedSignificantItem.doc_count,
            examples: []
          }])]
        }
      });
    }
  } else if (selectedGroup && !includeSelectedSignificantItem) {
    filterCriteria.push({
      bool: {
        must_not: [{
          bool: {
            filter: [...groupFilter]
          }
        }]
      }
    });
  }
  return filterCriteria;
}