"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSettings = exports.mapConfig = exports.initCategoryCounts = exports.initCategories = void 0;
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const mapConfig = config => {
  const all = config.getAll();
  return Object.entries(all).map(([settingId, settingDef]) => {
    return (0, _lib.toEditableConfig)({
      def: settingDef,
      name: settingId,
      value: settingDef.userValue,
      isCustom: config.isCustom(settingId),
      isOverridden: config.isOverridden(settingId)
    });
  }).filter(c => !c.readOnly).filter(c => !c.isCustom) // hide any settings that aren't explicitly registered by enabled plugins.
  .sort(_lib.fieldSorter);
};
exports.mapConfig = mapConfig;
const mapSettings = fieldSettings => {
  // Group settings by category
  return fieldSettings.reduce((grouped, setting) => {
    // We will want to change this logic when we put each category on its
    // own page aka allowing a setting to be included in multiple categories.
    const category = setting.category[0];
    (grouped[category] = grouped[category] || []).push(setting);
    return grouped;
  }, {});
};
exports.mapSettings = mapSettings;
const initCategoryCounts = grouped => {
  return Object.keys(grouped).reduce((counts, category) => {
    counts[category] = grouped[category].length;
    return counts;
  }, {});
};
exports.initCategoryCounts = initCategoryCounts;
const initCategories = grouped => {
  return Object.keys(grouped).sort((a, b) => {
    if (a === _lib.DEFAULT_CATEGORY) return -1;
    if (b === _lib.DEFAULT_CATEGORY) return 1;
    if (a > b) return 1;
    return a === b ? 0 : -1;
  });
};
exports.initCategories = initCategories;