"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nTexts = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const i18nTexts = {
  defaultSpaceTabTitle: _i18n.i18n.translate('advancedSettings.spaceSettingsTabTitle', {
    defaultMessage: 'Space Settings'
  }),
  defaultSpaceCalloutTitle: _i18n.i18n.translate('advancedSettings.defaultSpaceCalloutTitle', {
    defaultMessage: 'Changes will affect the current space.'
  }),
  defaultSpaceCalloutSubtitle: _i18n.i18n.translate('advancedSettings.defaultSpaceCalloutSubtitle', {
    defaultMessage: 'Changes will only be applied to the current space. These settings are intended for advanced users, as improper configurations may adversely affect aspects of Kibana.'
  }),
  globalTabTitle: _i18n.i18n.translate('advancedSettings.globalSettingsTabTitle', {
    defaultMessage: 'Global Settings'
  }),
  globalCalloutTitle: _i18n.i18n.translate('advancedSettings.globalCalloutTitle', {
    defaultMessage: 'Changes will affect all user settings across all spaces'
  }),
  globalCalloutSubtitle: _i18n.i18n.translate('advancedSettings.globalCalloutSubtitle', {
    defaultMessage: 'Changes will be applied to all users across all spaces. This includes both native Kibana users and single-sign on users.'
  }),
  advancedSettingsTitle: _i18n.i18n.translate('advancedSettings.advancedSettingsLabel', {
    defaultMessage: 'Advanced Settings'
  })
};
exports.i18nTexts = i18nTexts;