"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseErrorMsg = exports.Search = exports.CATEGORY_FIELD = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lib = require("../../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CATEGORY_FIELD = 'category';
exports.CATEGORY_FIELD = CATEGORY_FIELD;
const parseErrorMsg = _i18n.i18n.translate('advancedSettings.searchBar.unableToParseQueryErrorMessage', {
  defaultMessage: 'Unable to parse query'
});
exports.parseErrorMsg = parseErrorMsg;
class Search extends _react.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "categories", []);
    (0, _defineProperty2.default)(this, "state", {
      isSearchTextValid: true,
      parseErrorMessage: null
    });
    (0, _defineProperty2.default)(this, "onChange", ({
      query,
      error
    }) => {
      if (error) {
        this.setState({
          isSearchTextValid: false,
          parseErrorMessage: error.message
        });
        return;
      }
      this.setState({
        isSearchTextValid: true,
        parseErrorMessage: null
      });
      this.props.onQueryChange({
        query: query
      });
    });
    const {
      categories
    } = props;
    this.categories = categories.map(category => {
      return {
        value: category,
        name: (0, _lib.getCategoryName)(category)
      };
    });
  }
  render() {
    const {
      query
    } = this.props;
    const box = {
      incremental: true,
      'data-test-subj': 'settingsSearchBar',
      'aria-label': _i18n.i18n.translate('advancedSettings.searchBarAriaLabel', {
        defaultMessage: 'Search advanced settings'
      }) // hack until EuiSearchBar is fixed
    };

    const filters = [{
      type: 'field_value_selection',
      field: CATEGORY_FIELD,
      name: _i18n.i18n.translate('advancedSettings.categorySearchLabel', {
        defaultMessage: 'Category'
      }),
      multiSelect: 'or',
      options: this.categories
    }];
    let queryParseError;
    if (!this.state.isSearchTextValid) {
      queryParseError = /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, null, `${parseErrorMsg}. ${this.state.parseErrorMessage}`);
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
      box: box,
      filters: filters,
      onChange: this.onChange,
      query: query
    }), queryParseError);
  }
}
exports.Search = Search;