"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSystemConnectors = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSystemConnectors = actionTypes => {
  const systemActionTypes = actionTypes.filter(actionType => actionType.isSystemActionType);
  const systemConnectors = systemActionTypes.map(systemActionType => ({
    id: `system-connector-${systemActionType.id}`,
    actionTypeId: systemActionType.id,
    name: `System action: ${systemActionType.id}`,
    isMissingSecrets: false,
    config: {},
    secrets: {},
    isDeprecated: false,
    isPreconfigured: false,
    isSystemAction: true
  }));
  return systemConnectors;
};
exports.createSystemConnectors = createSystemConnectors;