"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncationUtils = void 0;
var _canvas = require("../../services/canvas");
var _excluded = ["fullText", "ellipsis", "availableWidth"];
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
/**
 * Utilities for truncating types at various positions, as well as
 * determining whether truncation is possible or even necessary.
 */
var TruncationUtils = /*#__PURE__*/function (_CanvasTextUtils) {
  _inherits(TruncationUtils, _CanvasTextUtils);
  var _super = _createSuper(TruncationUtils);
  function TruncationUtils(_ref) {
    var _this;
    var fullText = _ref.fullText,
      ellipsis = _ref.ellipsis,
      _availableWidth = _ref.availableWidth,
      rest = _objectWithoutProperties(_ref, _excluded);
    _classCallCheck(this, TruncationUtils);
    _this = _super.call(this, rest);
    _defineProperty(_assertThisInitialized(_this), "fullText", void 0);
    _defineProperty(_assertThisInitialized(_this), "ellipsis", void 0);
    _defineProperty(_assertThisInitialized(_this), "availableWidth", void 0);
    /**
     * Performance utilities
     */
    _defineProperty(_assertThisInitialized(_this), "debugPerformance", false);
    _defineProperty(_assertThisInitialized(_this), "debugCounter", 0);
    /**
     * Internal utils for calculating a ratio based on the passed available width
     * vs the full text width.
     * This ratio is used to get an initial _approximate_ text string that should
     * be slightly over the available width, which we can then remove from
     * character-by-character until the text just fits within the available width.
     */
    _defineProperty(_assertThisInitialized(_this), "widthRatio", 0);
    _defineProperty(_assertThisInitialized(_this), "setTextWidthRatio", function () {
      var text = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _this.fullText;
      var textToOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      // Account for reduced available width due to (e.g.) truncation offset
      var availableWidth = _this.availableWidth;
      if (textToOffset) {
        _this.setTextToCheck(textToOffset);
        availableWidth = availableWidth - _this.textWidth;
      }
      _this.setTextToCheck(text);
      _this.widthRatio = availableWidth / _this.textWidth;
    });
    _defineProperty(_assertThisInitialized(_this), "getTextFromRatio", function (text, type) {
      var characterRatio = Math.ceil(text.length * _this.widthRatio);
      var index = type === 'start' ? text.length - characterRatio : characterRatio;
      var _splitText$at = splitText(text).at(index),
        _splitText$at2 = _slicedToArray(_splitText$at, 2),
        end = _splitText$at2[0],
        start = _splitText$at2[1];
      return type === 'start' ? start : end;
    });
    /**
     * Early return checks
     */
    _defineProperty(_assertThisInitialized(_this), "checkIfTruncationIsNeeded", function () {
      _this.setTextToCheck(_this.fullText);
      if (_this.availableWidth >= _this.textWidth) {
        return false;
      }
    });
    _defineProperty(_assertThisInitialized(_this), "checkSufficientEllipsisWidth", function (truncation) {
      var textToCheck = truncation === 'startEnd' ? "".concat(_this.ellipsis, " ").concat(_this.ellipsis) // startEnd needs a little more space
      : _this.ellipsis;
      _this.setTextToCheck(textToCheck);
      if (_this.textWidth >= _this.availableWidth * 0.9) {
        console.error('The truncation ellipsis is larger than the available width. No text can be rendered.');
        return false;
      }
    });
    _defineProperty(_assertThisInitialized(_this), "checkTruncationOffsetWidth", function (text) {
      _this.setTextToCheck(text);
      if (_this.textWidth > _this.availableWidth) {
        console.error('The passed truncationOffset is too large for the available width. Truncating the offset instead.');
        return false;
      }
    });
    /**
     * Truncation types logic. This is where the magic happens
     */
    _defineProperty(_assertThisInitialized(_this), "truncateStart", function (truncationOffset) {
      var truncatedText = _this.fullText;
      var leadingText = '';
      var combinedText = function combinedText() {
        return leadingText + truncatedText;
      };
      if (truncationOffset) {
        var _splitText$at3 = splitText(_this.fullText).at(truncationOffset);
        var _splitText$at4 = _slicedToArray(_splitText$at3, 2);
        leadingText = _splitText$at4[0];
        truncatedText = _splitText$at4[1];
        var widthCheck = leadingText + _this.ellipsis;
        if (_this.checkTruncationOffsetWidth(widthCheck) === false) {
          truncatedText = leadingText;
          leadingText = '';
        }
      }

      // Get text width ratio width accounting for any truncation offset text,
      // and guesstimate an initial truncated string
      _this.setTextWidthRatio(truncatedText, leadingText);
      truncatedText = _this.getTextFromRatio(truncatedText, 'start');
      leadingText += _this.ellipsis;
      _this.setTextToCheck(combinedText());
      while (_this.textWidth > _this.availableWidth) {
        truncatedText = removeFirstCharacter(truncatedText);
        _this.setTextToCheck(combinedText());
      }
      return combinedText();
    });
    _defineProperty(_assertThisInitialized(_this), "truncateEnd", function (truncationOffset) {
      var truncatedText = _this.fullText;
      var trailingText = '';
      var combinedText = function combinedText() {
        return truncatedText + trailingText;
      };
      if (truncationOffset) {
        var index = _this.fullText.length - truncationOffset;
        var _splitText$at5 = splitText(_this.fullText).at(index);
        var _splitText$at6 = _slicedToArray(_splitText$at5, 2);
        truncatedText = _splitText$at6[0];
        trailingText = _splitText$at6[1];
        var widthCheck = _this.ellipsis + trailingText;
        if (_this.checkTruncationOffsetWidth(widthCheck) === false) {
          truncatedText = trailingText;
          trailingText = '';
        }
      }

      // Get text width ratio width accounting for any truncation offset text,
      // and guesstimate an initial truncated string
      _this.setTextWidthRatio(truncatedText, trailingText);
      truncatedText = _this.getTextFromRatio(truncatedText, 'end');
      trailingText = _this.ellipsis + trailingText;
      _this.setTextToCheck(combinedText());
      while (_this.textWidth > _this.availableWidth) {
        truncatedText = removeLastCharacter(truncatedText);
        _this.setTextToCheck(combinedText());
      }
      return combinedText();
    });
    _defineProperty(_assertThisInitialized(_this), "truncateStartEndAtPosition", function (truncationPosition) {
      // Split the text from the anchor position, using the width ratio
      // to get the starting and ending indices from the position
      _this.setTextWidthRatio();
      var characterRatio = Math.floor(_this.fullText.length * _this.widthRatio / 2);
      var truncateStart = truncationPosition - characterRatio;
      var truncateEnd = truncationPosition + characterRatio;

      // If either of the approximate start/end truncation indices go beyond the
      // bounds of the actual text, we can simply use end or start truncation instead
      if (truncateStart < 0) {
        return _this.truncateEnd();
      }
      if (truncateEnd >= _this.fullText.length) {
        return _this.truncateStart();
      }
      var truncatedText = _this.fullText.substring(truncateStart, truncateEnd);
      var combinedText = function combinedText() {
        return _this.ellipsis + truncatedText + _this.ellipsis;
      };
      _this.setTextToCheck(combinedText());
      var alternating;
      while (_this.textWidth > _this.availableWidth) {
        truncatedText = alternating ? removeLastCharacter(truncatedText) : removeFirstCharacter(truncatedText);
        alternating = !alternating;
        _this.setTextToCheck(combinedText());
      }
      return combinedText();
    });
    _defineProperty(_assertThisInitialized(_this), "truncateStartEndAtMiddle", function () {
      var middlePosition = Math.floor(_this.fullText.length / 2);
      return _this.truncateStartEndAtPosition(middlePosition);
    });
    _defineProperty(_assertThisInitialized(_this), "truncateMiddle", function () {
      var middlePosition = Math.floor(_this.fullText.length / 2);
      var _splitText$at7 = splitText(_this.fullText).at(middlePosition),
        _splitText$at8 = _slicedToArray(_splitText$at7, 2),
        firstHalf = _splitText$at8[0],
        secondHalf = _splitText$at8[1];
      _this.setTextWidthRatio();
      firstHalf = _this.getTextFromRatio(firstHalf, 'end');
      secondHalf = _this.getTextFromRatio(secondHalf, 'start');
      var combinedText = function combinedText() {
        return firstHalf + _this.ellipsis + secondHalf;
      };
      _this.setTextToCheck(combinedText());
      var alternating;
      while (_this.textWidth > _this.availableWidth) {
        alternating = !alternating;
        if (alternating) {
          firstHalf = removeLastCharacter(firstHalf);
        } else {
          secondHalf = removeFirstCharacter(secondHalf);
        }
        _this.setTextToCheck(combinedText());
      }
      return combinedText();
    });
    _this.fullText = fullText;
    _this.ellipsis = ellipsis;
    _this.availableWidth = _availableWidth;
    return _this;
  }
  _createClass(TruncationUtils, [{
    key: "textWidth",
    get: function get() {
      if (this.debugPerformance) {
        this.debugCounter++;
      }
      return _get(_getPrototypeOf(TruncationUtils.prototype), "textWidth", this);
    }
  }]);
  return TruncationUtils;
}(_canvas.CanvasTextUtils);
/**
 * DRY character/substring utils
 */
exports.TruncationUtils = TruncationUtils;
var removeLastCharacter = function removeLastCharacter(text) {
  return text.substring(0, text.length - 1);
};
var removeFirstCharacter = function removeFirstCharacter(text) {
  return text.substring(1);
};
var splitText = function splitText(text) {
  return {
    at: function at(index) {
      return [text.substring(0, index), text.substring(index)];
    }
  };
};