"use strict";

var _react = _interopRequireDefault(require("react"));
var _resizable_container = require("./resizable_container");
var _text = require("../text");
var _faker = require("@faker-js/faker");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var text = (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("p", null, _faker.faker.lorem.paragraphs()), (0, _react2.jsx)("p", null, _faker.faker.lorem.paragraphs()), (0, _react2.jsx)("p", null, _faker.faker.lorem.paragraphs()));
describe('Horizontal EuiResizableContainer', function () {
  var HorizontalContainer = function HorizontalContainer() {
    return (0, _react2.jsx)(_resizable_container.EuiResizableContainer, {
      style: {
        height: '200px'
      }
    }, function (EuiResizablePanel, EuiResizableButton) {
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(EuiResizablePanel, {
        initialSize: 50,
        minSize: "30%",
        tabIndex: 0
      }, (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("div", null, text), (0, _react2.jsx)("a", {
        href: "#",
        "data-test-subj": "hello-world-link"
      }, "Hello world"))), (0, _react2.jsx)(EuiResizableButton, null), (0, _react2.jsx)(EuiResizablePanel, {
        initialSize: 50,
        minSize: "200px",
        tabIndex: 0
      }, (0, _react2.jsx)(_text.EuiText, null, text)));
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(HorizontalContainer, null));
    cy.get('div.euiResizablePanel').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when first panel is scrolled vertically', function () {
      cy.realPress('Tab');
      cy.get('div.euiPanel').first().should('have.focus');
      cy.realPress('End');
      cy.get('a[data-test-subj="hello-world-link"]').should('be.visible');
      cy.checkAxe();
    });
    it('has zero violations when second panel is scrolled vertically', function () {
      cy.repeatRealPress('Tab', 4);
      cy.get('div.euiPanel').last().should('have.focus');
      cy.realPress('End');
      cy.realPress('Home');
      cy.checkAxe();
    });
    it('has zero violations when the horizontal panels are resized', function () {
      cy.repeatRealPress('Tab', 3);
      cy.get('button.euiResizableButton').should('have.focus');
      cy.repeatRealPress('ArrowRight', 10);
      cy.checkAxe();
    });
  });
});
describe('Vertical EuiResizableContainer', function () {
  var VerticalContainer = function VerticalContainer() {
    return (0, _react2.jsx)(_resizable_container.EuiResizableContainer, {
      style: {
        height: '400px'
      },
      direction: "vertical"
    }, function (EuiResizablePanel, EuiResizableButton) {
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(EuiResizablePanel, {
        initialSize: 60,
        minSize: "40%",
        tabIndex: 0
      }, (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("div", null, text))), (0, _react2.jsx)(EuiResizableButton, null), (0, _react2.jsx)(EuiResizablePanel, {
        initialSize: 40,
        minSize: "10%",
        tabIndex: 0
      }, (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("div", null, text))));
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(VerticalContainer, null));
    cy.get('div.euiResizablePanel').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the vertical panels are resized', function () {
      cy.repeatRealPress('Tab');
      cy.get('button.euiResizableButton').should('have.focus');
      cy.repeatRealPress('ArrowDown', 10);
      cy.checkAxe();
    });
  });
});