"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsNestedEuiProvider = exports.EuiProviderNestedCheck = exports.EuiNestedProviderContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This util creates a context for EuiProviders to use and determine if they're
 * the only (top-most) EuiProvider in the app. If they aren't (i.e., they're
 * nested within another EuiProvider) we should throw a warning and not
 * render instantiate the nested EuiProvider.
 */

var EuiNestedProviderContext = /*#__PURE__*/(0, _react.createContext)(false);
exports.EuiNestedProviderContext = EuiNestedProviderContext;
var EuiProviderNestedCheck = function EuiProviderNestedCheck(_ref) {
  var children = _ref.children;
  return (0, _react2.jsx)(EuiNestedProviderContext.Provider, {
    value: true
  }, children);
};
exports.EuiProviderNestedCheck = EuiProviderNestedCheck;
var useIsNestedEuiProvider = function useIsNestedEuiProvider() {
  return !!(0, _react.useContext)(EuiNestedProviderContext);
};
exports.useIsNestedEuiProvider = useIsNestedEuiProvider;