"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPageInnerStyles = void 0;
var _react = require("@emotion/react");
var _mixins = require("../../../themes/amsterdam/global_styling/mixins");
var _global_styling = require("../../../global_styling");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiPageInnerStyles = function euiPageInnerStyles(euiThemeContext) {
  var borderColor = (0, _services.transparentize)(euiThemeContext.euiTheme.colors.lightShade, 0.7);
  return {
    euiPageInner: /*#__PURE__*/(0, _react.css)("display:flex;flex-direction:column;align-items:stretch;flex:1 1 100%;", (0, _global_styling.logicalCSS)('max-width', '100%'), " ", (0, _global_styling.logicalCSS)('min-width', '0'), ";;label:euiPageInner;"),
    panelled: /*#__PURE__*/(0, _react.css)("background:", (0, _global_styling.euiBackgroundColor)(euiThemeContext, 'plain'), ";", (0, _mixins.euiShadow)(euiThemeContext, 'm'), ";;label:panelled;"),
    border: {
      top: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', "".concat(euiThemeContext.euiTheme.border.width.thin, " solid ").concat(borderColor)), ";;label:top;"),
      left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-left', "".concat(euiThemeContext.euiTheme.border.width.thin, " solid ").concat(borderColor)), ";;label:left;")
    }
  };
};
exports.euiPageInnerStyles = euiPageInnerStyles;