"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiListGroupItemTooltipStyles = exports.euiListGroupItemStyles = exports.euiListGroupItemLabelStyles = exports.euiListGroupItemInnerStyles = exports.euiListGroupItemIconStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _button = require("../../themes/amsterdam/global_styling/mixins/button");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var euiListGroupItemStyles = function euiListGroupItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var primaryBgColor = (0, _global_styling.euiBackgroundColor)(euiThemeContext, 'primary', {
    method: 'transparent'
  });
  var subduedBgColor = (0, _global_styling.euiBackgroundColor)(euiThemeContext, 'subdued', {
    method: 'transparent'
  });
  return {
    // Base
    euiListGroupItem: /*#__PURE__*/(0, _react.css)("padding:0;display:flex;align-items:center;position:relative;", _global_styling.euiCanAnimate, "{transition:background-color ", euiTheme.animation.fast, ";};label:euiListGroupItem;"),
    // Sizes
    xs: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.small, ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.small, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";;label:l;"),
    // Colors
    colors: {
      isActive: {
        primary: /*#__PURE__*/(0, _react.css)("background-color:", primaryBgColor, ";;label:primary;"),
        text: /*#__PURE__*/(0, _react.css)("background-color:", subduedBgColor, ";;label:text;"),
        subdued: /*#__PURE__*/(0, _react.css)("background-color:", subduedBgColor, ";;label:subdued;")
      },
      isClickable: {
        primary: /*#__PURE__*/(0, _react.css)("&:hover,&:focus-within{background-color:", primaryBgColor, ";};label:primary;"),
        text: /*#__PURE__*/(0, _react.css)("&:hover,&:focus-within{background-color:", subduedBgColor, ";};label:text;"),
        subdued: /*#__PURE__*/(0, _react.css)("&:hover,&:focus-within{background-color:", subduedBgColor, ";};label:subdued;")
      }
    }
  };
};
exports.euiListGroupItemStyles = euiListGroupItemStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1sre2yb-isClickable",
  styles: "&:hover,&:focus{text-decoration:underline;};label:isClickable;"
} : {
  name: "1sre2yb-isClickable",
  styles: "&:hover,&:focus{text-decoration:underline;};label:isClickable;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiListGroupItemInnerStyles = function euiListGroupItemInnerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiListGroupItem__inner: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalShorthandCSS)('padding', "".concat(euiTheme.size.xs, " ").concat(euiTheme.size.s)), " display:flex;align-items:center;flex-grow:1;max-inline-size:100%;overflow:hidden;text-align:start;font-weight:inherit;;label:euiListGroupItem__inner;"),
    // Sizes
    xs: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.medium, ";letter-spacing:0;", (0, _global_styling.logicalCSS)('min-height', euiTheme.size.l), ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), " font-weight:", euiTheme.font.weight.medium, ";letter-spacing:0;", (0, _global_styling.logicalCSS)('min-height', euiTheme.size.xl), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'm'), " ", (0, _global_styling.logicalCSS)('min-height', euiTheme.size.xl), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'l'), " ", (0, _global_styling.logicalCSS)('min-height', euiTheme.size.xxl), ";;label:l;"),
    // Colors
    primary: /*#__PURE__*/(0, _react.css)("color:", (0, _button.euiButtonColor)(euiThemeContext, 'primary').color, ";;label:primary;"),
    text: /*#__PURE__*/(0, _react.css)("color:", (0, _button.euiButtonColor)(euiThemeContext, 'text').color, ";;label:text;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    ghost: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.ghost, ";;label:ghost;"),
    // Variants
    isDisabled: /*#__PURE__*/(0, _react.css)("cursor:not-allowed;&,&:hover,&:focus{color:", (0, _button.euiButtonColor)(euiThemeContext, 'disabled').color, ";cursor:not-allowed;background-color:transparent;text-decoration:none;};label:isDisabled;"),
    isActive: /*#__PURE__*/(0, _react.css)(";label:isActive;"),
    isClickable: _ref
  };
};
exports.euiListGroupItemInnerStyles = euiListGroupItemInnerStyles;
var euiListGroupItemLabelStyles = function euiListGroupItemLabelStyles() {
  return {
    // Base
    euiListGroupItem__label: /*#__PURE__*/(0, _react.css)(";label:euiListGroupItem__label;"),
    truncate: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), ";;label:truncate;"),
    wrapText: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextBreakWord)(), ";;label:wrapText;")
  };
};
exports.euiListGroupItemLabelStyles = euiListGroupItemLabelStyles;
var euiListGroupItemIconStyles = function euiListGroupItemIconStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    // Base
    euiListGroupItem__icon: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-right', euiTheme.size.m), " flex-grow:0;flex-shrink:0;;label:euiListGroupItem__icon;")
  };
};
exports.euiListGroupItemIconStyles = euiListGroupItemIconStyles;
var euiListGroupItemTooltipStyles = function euiListGroupItemTooltipStyles() {
  return {
    // Base
    euiListGroupItem__tooltip: /*#__PURE__*/(0, _react.css)("display:inline-flex;", (0, _global_styling.logicalCSS)('width', '100%'), ";;label:euiListGroupItem__tooltip;")
  };
};
exports.euiListGroupItemTooltipStyles = euiListGroupItemTooltipStyles;