"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImageWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _image_wrapper = require("./image_wrapper.styles");
var _image_button = require("./image_button");
var _image_caption = require("./image_caption");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */
var EuiImageWrapper = function EuiImageWrapper(_ref) {
  var alt = _ref.alt,
    caption = _ref.caption,
    hasShadow = _ref.hasShadow,
    allowFullScreen = _ref.allowFullScreen,
    float = _ref.float,
    margin = _ref.margin,
    children = _ref.children,
    setIsFullScreen = _ref.setIsFullScreen,
    wrapperProps = _ref.wrapperProps,
    fullScreenIconColor = _ref.fullScreenIconColor,
    isFullWidth = _ref.isFullWidth,
    onFullScreen = _ref.onFullScreen;
  var openFullScreen = function openFullScreen() {
    setIsFullScreen(true);
    onFullScreen === null || onFullScreen === void 0 ? void 0 : onFullScreen(true);
  };
  var classes = (0, _classnames.default)('euiImageWrapper', wrapperProps && wrapperProps.className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _image_wrapper.euiImageWrapperStyles)(euiTheme);
  var cssFigureStyles = [styles.euiImageWrapper, float && styles[float], margin && styles[margin], allowFullScreen && styles.allowFullScreen, isFullWidth && styles.fullWidth, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    optionalCaptionRef = _useInnerText2[0],
    optionalCaptionText = _useInnerText2[1];
  return (0, _react2.jsx)("figure", _extends({
    "aria-label": optionalCaptionText
  }, wrapperProps, {
    className: classes,
    css: cssFigureStyles
  }), allowFullScreen ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_image_button.EuiImageButton, {
    hasAlt: !!alt,
    hasShadow: hasShadow,
    onClick: openFullScreen,
    "data-test-subj": "activateFullScreenButton",
    isFullWidth: isFullWidth,
    fullScreenIconColor: fullScreenIconColor
  }, children)) : children, (0, _react2.jsx)(_image_caption.EuiImageCaption, {
    ref: optionalCaptionRef,
    caption: caption
  }));
};
exports.EuiImageWrapper = EuiImageWrapper;
EuiImageWrapper.propTypes = {
  isFullWidth: _propTypes.default.bool.isRequired,
  setIsFullScreen: _propTypes.default.func.isRequired
};