"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDescriptionList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _description_list_context = require("./description_list_context");
var _description_list_title = require("./description_list_title");
var _description_list_description = require("./description_list_description");
var _description_list = require("./description_list.styles");
var _react2 = require("@emotion/react");
var _excluded = ["align", "children", "className", "style", "compressed", "descriptionProps", "listItems", "textStyle", "titleProps", "type", "rowGutterSize", "columnGutterSize", "columnWidths"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiDescriptionList = function EuiDescriptionList(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? 'left' : _ref$align,
    children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    descriptionProps = _ref.descriptionProps,
    listItems = _ref.listItems,
    _ref$textStyle = _ref.textStyle,
    textStyle = _ref$textStyle === void 0 ? 'normal' : _ref$textStyle,
    titleProps = _ref.titleProps,
    _ref$type = _ref.type,
    _type = _ref$type === void 0 ? 'row' : _ref$type,
    _ref$rowGutterSize = _ref.rowGutterSize,
    rowGutterSize = _ref$rowGutterSize === void 0 ? 's' : _ref$rowGutterSize,
    _ref$columnGutterSize = _ref.columnGutterSize,
    columnGutterSize = _ref$columnGutterSize === void 0 ? 's' : _ref$columnGutterSize,
    columnWidths = _ref.columnWidths,
    rest = _objectWithoutProperties(_ref, _excluded);
  var showResponsiveColumns = (0, _services.useIsWithinBreakpoints)(['xs', 's']);
  var type = (0, _react.useMemo)(function () {
    if (_type === 'responsiveColumn') {
      return showResponsiveColumns ? 'row' : 'column';
    } else {
      return _type;
    }
  }, [_type, showResponsiveColumns]);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _description_list.euiDescriptionListStyles)(euiTheme);
  var cssStyles = [styles.euiDescriptionList, styles[type], styles[align], type === 'column' && styles.rowGap[rowGutterSize], type === 'column' && styles.columnGap[columnGutterSize]];
  var inlineStyles = (0, _react.useMemo)(function () {
    if (type === 'column' && columnWidths) {
      // Leave string values as is - e.g. if a consumer passes in a specific '200px' or 'minmax()'
      var convertNumbersToFr = function convertNumbersToFr(value) {
        return typeof value === 'number' ? "".concat(value, "fr") : value;
      };
      var titleWidth = convertNumbersToFr(columnWidths[0]);
      var descriptionWidth = convertNumbersToFr(columnWidths[1]);
      return _objectSpread({
        gridTemplateColumns: "".concat(titleWidth, " ").concat(descriptionWidth)
      }, style);
    }
    return style;
  }, [style, type, columnWidths]);
  var classes = (0, _classnames.default)('euiDescriptionList', className);
  var childrenOrListItems = null;
  if (listItems) {
    childrenOrListItems = listItems.map(function (item, index) {
      return [(0, _react2.jsx)(_description_list_title.EuiDescriptionListTitle, _extends({
        key: "title-".concat(index)
      }, titleProps), item.title), (0, _react2.jsx)(_description_list_description.EuiDescriptionListDescription, _extends({
        key: "description-".concat(index)
      }, descriptionProps), item.description)];
    });
  } else {
    childrenOrListItems = children;
  }
  return (0, _react2.jsx)(_description_list_context.EuiDescriptionListContext.Provider, {
    value: {
      type: type,
      compressed: compressed,
      textStyle: textStyle,
      align: align,
      rowGutterSize: rowGutterSize
    }
  }, (0, _react2.jsx)("dl", _extends({
    className: classes,
    css: cssStyles,
    style: inlineStyles
  }, rest, {
    "data-type": _type
  }), childrenOrListItems));
};
exports.EuiDescriptionList = EuiDescriptionList;
EuiDescriptionList.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  listItems: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.any.isRequired,
    description: _propTypes.default.any.isRequired
  }).isRequired),
  /**
     * Text alignment
     */
  align: _propTypes.default.any,
  /**
     * Smaller text and condensed spacing
     */
  compressed: _propTypes.default.bool,
  /**
     * How should the content be styled, by default
     * this will emphasize the title
     */
  textStyle: _propTypes.default.oneOf(["normal", "reverse"]),
  /**
     * How each item should be laid out
     */
  type: _propTypes.default.any,
  /**
     * Props object to be passed to `EuiDescriptionListTitle`
     */
  titleProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  /**
     * Props object to be passed to `EuiDescriptionListDescription`
     */
  descriptionProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  /**
     * Allows customizing the vertical spacing between rows.
     */
  rowGutterSize: _propTypes.default.any,
  /**
     * Allows customizing the horizontal spacing between columns.
     *
     * Only applies to `column` and `responsiveColumn` types.
     */
  columnGutterSize: _propTypes.default.any,
  /**
     * Allows customizing specific column widths (e.g. `['100px', '200px']`). The first
     * array value applies to the title column, and the second applies to the description column.
     *
     * Passing numbers instead of CSS width strings will use a ratio of widths.
     * For example, [1, 3] will render a description column 3x the width of the title column.
     * In other words, descriptions will have a width of `75%` and titles will have a width of `25%`.
     *
     * Only applies to `column` and `responsiveColumn` types.
     *
     * _Advanced usage note:_ column width strings also accept [CSS grid special units,
     * sizing, keywords, and sizing functions](https://css-tricks.com/snippets/css/complete-guide-grid/#aa-special-units-functions).
     */
  columnWidths: _propTypes.default.any
};