"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCard = exports.ALIGNMENTS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _accessibility = require("../../services/accessibility");
var _href_validator = require("../../services/security/href_validator");
var _text = require("../text");
var _title = require("../title");
var _beta_badge = require("../badge/beta_badge");
var _panel = require("../panel");
var _spacer = require("../spacer");
var _card_select = require("./card_select");
var _card = require("./card.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "description", "isDisabled", "title", "titleElement", "titleSize", "icon", "image", "children", "footer", "onClick", "href", "rel", "target", "textAlign", "betaBadgeProps", "layout", "selectable", "display", "paddingSize"],
  _excluded2 = ["anchorProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var ALIGNMENTS = ['left', 'center', 'right'];

/**
 * Certain props are only allowed when the layout is vertical
 */
exports.ALIGNMENTS = ALIGNMENTS;
var EuiCard = function EuiCard(_ref) {
  var className = _ref.className,
    description = _ref.description,
    _isDisabled = _ref.isDisabled,
    title = _ref.title,
    _ref$titleElement = _ref.titleElement,
    titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    icon = _ref.icon,
    image = _ref.image,
    children = _ref.children,
    footer = _ref.footer,
    onClick = _ref.onClick,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    _ref$textAlign = _ref.textAlign,
    textAlign = _ref$textAlign === void 0 ? 'center' : _ref$textAlign,
    betaBadgeProps = _ref.betaBadgeProps,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    selectable = _ref.selectable,
    display = _ref.display,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var isDisabled = _isDisabled || !isHrefValid;
  var isClickable = !isDisabled && (onClick || href || selectable && !selectable.isDisabled);
  var euiThemeContext = (0, _services.useEuiTheme)();
  var styles = (0, _card.euiCardStyles)(euiThemeContext, paddingSize);
  var cardStyles = [styles.card.euiCard,
  // Text alignment should always be left when horizontal
  styles.card.aligned[layout === 'horizontal' ? 'left' : textAlign], isDisabled && styles.card.disabled];
  var contentStyles = [styles.content.euiCard__content, styles.content.layout[layout]];
  var mainStyles = [styles.main.euiCard__main, styles.main.layout[layout]];
  var textStyles = (0, _card.euiCardTextStyles)(euiThemeContext);
  var textCSS = [textStyles.euiCard__text,
  // Text alignment should always be left when horizontal
  textStyles.aligned[layout === 'horizontal' ? 'left' : textAlign], isClickable && textStyles.interactive, isDisabled && textStyles.disabled];

  /**
   * For a11y, we simulate the same click that's provided on the title when clicking the whole card
   * without having to make the whole card a button or anchor tag.
   * *Card Accessibility: The redundant click event https://inclusive-components.design/cards/*
   */
  var link = null;
  var outerOnClick = function outerOnClick(e) {
    if (link && link !== e.target && !link.contains(e.target)) {
      link.click();
    }
  };
  if (layout === 'horizontal') {
    if (image || footer || textAlign !== 'center') {
      throw new Error('EuiCard: `layout="horizontal"` cannot be used in conjunction with `image`, `footer`, or `textAlign`.');
    }
  }
  var classes = (0, _classnames.default)('euiCard', className);
  var ariaId = (0, _accessibility.useGeneratedHtmlId)();
  var ariaDesc = description ? "".concat(ariaId, "Description") : '';

  /**
   * Top area containing image, icon or both
   */

  var imageNode;
  if (image && layout === 'vertical') {
    if ( /*#__PURE__*/(0, _react.isValidElement)(image) || typeof image === 'string') {
      var imageStyles = [styles.image.euiCard__image, display === 'transparent' && styles.image.transparent];
      imageNode = (0, _react2.jsx)("div", {
        className: "euiCard__image",
        css: imageStyles
      }, /*#__PURE__*/(0, _react.isValidElement)(image) ? image : (0, _react2.jsx)("img", {
        src: image,
        alt: ""
      }));
    } else {
      imageNode = null;
    }
  }
  var iconNode;
  if (icon) {
    var iconStyles = [styles.icon.euiCard__icon, styles.icon.layout[layout], imageNode && styles.icon.withImage];
    iconNode = (0, _services.cloneElementWithCss)(icon, {
      className: (0, _classnames.default)(icon.props.className, 'euiCard__icon'),
      css: iconStyles
    });
  }
  var optionalCardTop;
  if (imageNode || iconNode) {
    var topStyles = [styles.top.euiCard__top, styles.top.layout[layout], isDisabled && styles.top.disabled];
    optionalCardTop = (0, _react2.jsx)("div", {
      className: "euiCard__top",
      css: topStyles
    }, imageNode, iconNode);
  }

  /**
   * Optional EuiBetaBadge
   */

  var optionalBetaBadge;
  var optionalBetaBadgeID = '';
  var optionalBetaCSS;
  if (betaBadgeProps !== null && betaBadgeProps !== void 0 && betaBadgeProps.label) {
    var betaStyles = (0, _card.euiCardBetaBadgeStyles)(euiThemeContext, paddingSize);
    optionalBetaCSS = betaStyles.hasBetaBadge;
    var anchorProps = betaBadgeProps.anchorProps,
      cleanedBetaBadgeProps = _objectWithoutProperties(betaBadgeProps, _excluded2);
    var anchorCSS = [betaStyles.euiCard__betaBadgeAnchor, anchorProps === null || anchorProps === void 0 ? void 0 : anchorProps.css];
    var badgeCSS = [betaStyles.euiCard__betaBadge, betaBadgeProps === null || betaBadgeProps === void 0 ? void 0 : betaBadgeProps.css];
    optionalBetaBadgeID = "".concat(ariaId, "BetaBadge");
    optionalBetaBadge = (0, _react2.jsx)(_beta_badge.EuiBetaBadge, _extends({
      color: isDisabled && !betaBadgeProps.onClick && !betaBadgeProps.href ? 'subdued' : 'hollow'
    }, cleanedBetaBadgeProps, {
      css: badgeCSS,
      anchorProps: _objectSpread(_objectSpread({}, anchorProps), {}, {
        css: anchorCSS
      }),
      id: optionalBetaBadgeID
    }));

    // Increase padding size when there is a beta badge unless it's already determined
    // paddingSize = paddingSize || 'l';
  }

  /**
   * Optional selectable button
   */

  if (selectable && isDisabled && selectable.isDisabled === undefined) {
    selectable.isDisabled = isDisabled;
  }
  var optionalSelectButton;
  if (selectable) {
    optionalSelectButton = (0, _react2.jsx)(_react.default.Fragment, null, paddingSize !== 'none' && (0, _react2.jsx)(_spacer.EuiSpacer, {
      size: paddingSize || 'm'
    }), (0, _react2.jsx)(_card_select.EuiCardSelect, _extends({
      "aria-describedby": "".concat(ariaId, "Title ").concat(ariaDesc)
    }, selectable, {
      buttonRef: function buttonRef(node) {
        link = node;
      }
    })));
  }
  var TitleElement = titleElement;

  /**
   * Wraps the title with the link (<a>) or button.
   * This makes the title element a11y friendly and gets described by its content if its interactable.
   */

  var theTitle;
  if (!isDisabled && href) {
    theTitle = (0, _react2.jsx)("a", {
      className: "euiCard__titleAnchor",
      css: textCSS,
      onClick: onClick,
      href: href,
      target: target,
      "aria-describedby": ariaDesc,
      rel: (0, _services.getSecureRelForTarget)({
        href: href,
        target: target,
        rel: rel
      }),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else if (isDisabled || onClick) {
    theTitle = (0, _react2.jsx)("button", {
      className: "euiCard__titleButton",
      css: textCSS,
      onClick: onClick,
      disabled: isDisabled,
      "aria-describedby": "".concat(optionalBetaBadgeID, " ").concat(ariaDesc),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else {
    theTitle = (0, _react2.jsx)("span", {
      css: textCSS
    }, title);
  }

  /**
   * Children and/or Description content
   */
  var optionalChildren;
  if (children) {
    var childrenStyles = [styles.euiCard__children];
    optionalChildren = (0, _react2.jsx)("div", {
      css: childrenStyles
    }, children);
  }
  var optionalDescription;
  if (description) {
    var descriptionStyles = [styles.euiCard__description];
    optionalDescription = (0, _react2.jsx)(_text.EuiText, {
      id: ariaDesc,
      size: "s",
      css: descriptionStyles
    }, (0, _react2.jsx)("p", null, description));
  }

  /**
   * Footer content
   */
  var optionalFooter;
  if (layout === 'vertical' && footer) {
    var footerStyles = [styles.euiCard__footer];
    optionalFooter = (0, _react2.jsx)("div", {
      css: footerStyles
    }, footer);
  }
  return (0, _react2.jsx)(_panel.EuiPanel, _extends({
    element: "div",
    className: classes,
    css: [].concat(cardStyles, [optionalBetaCSS]),
    onClick: isClickable ? outerOnClick : undefined,
    color: isDisabled ? 'subdued' : display,
    hasShadow: isDisabled || display ? false : true,
    hasBorder: display ? false : undefined,
    paddingSize: paddingSize
  }, rest), (0, _react2.jsx)("div", {
    className: "euiCard__main",
    css: mainStyles
  }, optionalCardTop, (0, _react2.jsx)("div", {
    className: "euiCard__content",
    css: contentStyles
  }, (0, _react2.jsx)(_title.EuiTitle, {
    id: "".concat(ariaId, "Title"),
    className: "euiCard__title",
    size: titleSize
  }, (0, _react2.jsx)(TitleElement, null, theTitle)), optionalDescription, optionalChildren), optionalBetaBadge, optionalFooter), optionalSelectButton);
};
exports.EuiCard = EuiCard;
EuiCard.propTypes = {
  /**
       * Change to "horizontal" if you need the icon to be left of the content.
       * Horizontal layouts cannot be used in conjunction with `image`, `footer`, or `textAlign`.
       */
  layout: _propTypes.default.oneOfType([_propTypes.default.oneOf(["vertical"]), _propTypes.default.oneOf(["horizontal"]).isRequired]),
  /**
       * Changes alignment of the title and description
       */
  textAlign: _propTypes.default.any,
  /**
       * Accepts any combination of elements
       */
  footer: _propTypes.default.node,
  /**
       * Accepts a url in string form or ReactElement for a custom image component
       */
  image: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]),
  /**
       * Cards are required to have at least a title and a description and/or children
       */
  title: _propTypes.default.any.isRequired,
  /**
       * Determines the title's heading element
       */
  titleElement: _propTypes.default.oneOf(["h2", "h3", "h4", "h5", "h6", "span", "p"]),
  /**
       * Determines the title's size, matching that of EuiTitle.
       * Though, card titles can't be too large or small relative to the description text.
       */
  titleSize: _propTypes.default.oneOf(["s", "xs"]),
  /**
       * Placed within a small EuiText `<p>` tag
       */
  description: _propTypes.default.any,
  /**
       * Accepts an `<EuiIcon>` node or `null`
       */
  icon: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.oneOf([null])]),
  /**
       * Custom children
       */
  children: _propTypes.default.node,
  /**
       * Use only if you want to forego a button in the footer and make the whole card clickable
       */
  onClick: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired]),
  isDisabled: _propTypes.default.bool,
  href: _propTypes.default.string,
  target: _propTypes.default.string,
  rel: _propTypes.default.string,
  /**
       * Adds a badge to top of the card to label it as "Beta" or other non-GA state.
       * Accepts all the props of [EuiBetaBadge](#/display/badge#beta-badge-type), where `label` is required.
       */
  betaBadgeProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
       * Will apply an onclick to the badge itself
       */
    onClick: _propTypes.default.func,
    /**
       * Aria label applied to the onClick button
       */
    onClickAriaLabel: _propTypes.default.any,
    href: _propTypes.default.string,
    target: _propTypes.default.string,
    rel: _propTypes.default.string,
    /**
       * Supply an icon type if the badge should just be an icon
       */
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "error", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
    /**
       * One word label like "Beta" or "Lab"
       */
    /**
       * One word label like "Beta" or "Lab"
       */
    label: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.string.isRequired]).isRequired]).isRequired,
    /**
       * Content for the tooltip
       */
    tooltipContent: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.node.isRequired])]),
    /**
       * Custom position of the tooltip
       */
    tooltipPosition: _propTypes.default.oneOf(["top", "right", "bottom", "left"]),
    /**
       * Passes onto the span wrapping the badge
       */
    anchorProps: _propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any
    }),
    /**
       * Optional title will be supplied as tooltip title or title attribute
       * otherwise the label will be used
       */
    title: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.string])]),
    /**
       * Accepts accent, subdued and hollow.
       */
    color: _propTypes.default.any,
    size: _propTypes.default.any,
    /**
       * Sets the `vertical-align` CSS property
       */
    alignment: _propTypes.default.any
  }),
  /**
       * Matches to the color property of EuiPanel. If defined, removes any border & shadow.
       * Leave as `undefined` to display as a default panel.
       * Selectable cards will always display as a default panel.
       */
  display: _propTypes.default.any,
  /**
       * Padding applied around the content of the card
       */
  paddingSize: _propTypes.default.any,
  /**
       * Adds a button to the bottom of the card to allow for in-place selection
       */
  selectable: _propTypes.default.shape({
    href: _propTypes.default.string,
    onClick: _propTypes.default.func,
    children: _propTypes.default.node,
    /**
       * Make button a solid color for prominence
       */
    /**
       * Make button a solid color for prominence
       */
    fill: _propTypes.default.bool,
    /**
       * Any of the named color palette options.
       */
    color: _propTypes.default.any,
    /**
       * Use size `s` in confined spaces
       */
    /**
       * Use size `s` in confined spaces
       */
    size: _propTypes.default.any,
    /**
       * `disabled` is also allowed
       */
    /**
       * `disabled` is also allowed
       */
    isDisabled: _propTypes.default.bool,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    buttonRef: _propTypes.default.any
  }),
  /**
       * Use a border style of card instead of shadow
       */
  hasBorder: _propTypes.default.bool
};