"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBottomBarStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
var euiBottomBarAppear = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: translateY(100%);\n    opacity: 0;\n  }\n\n  100% {\n    transform: translateY(0%);\n    opacity: 1;\n  }\n"])));
var euiBottomBarStyles = function euiBottomBarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    // `color` is inherited from the wrapping `EuiThemeProvider colorMode="dark"`
    euiBottomBar: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadowFlat)(euiThemeContext), " background:", (0, _services.shade)(euiTheme.colors.lightestShade, 0.5), ";", _global_styling.euiCanAnimate, "{animation:", euiBottomBarAppear, " ", euiTheme.animation.slow, " ", euiTheme.animation.resistance, ";};label:euiBottomBar;"),
    static: /*#__PURE__*/(0, _react.css)(";label:static;"),
    fixed: /*#__PURE__*/(0, _react.css)("z-index:", Number(euiTheme.levels.header) - 2, ";;label:fixed;"),
    sticky: /*#__PURE__*/(0, _react.css)("z-index:", Number(euiTheme.levels.header) - 2, ";;label:sticky;"),
    // Padding
    s: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.l, ";;label:l;"),
    none: ''
  };
};
exports.euiBottomBarStyles = euiBottomBarStyles;