# APM Integration

Elastic APM is an application performance monitoring system built on the Elastic Stack. It allows you to monitor software services and applications in real-time, by collecting detailed performance information on response time for incoming requests, database queries, calls to caches, external HTTP requests, and more.

The APM integration installs templates and pipelines that validate and process APM data.
To learn more about the APM Integration architecture, see [APM Components](https://ela.st/apm-components).

### Quick start

Ready to jump in? Read the [APM quick start](https://ela.st/quick-start-apm).

## Data Streams

When using the APM integration, APM events are indexed into data streams.
See [APM data streams](https://ela.st/apm-data-streams) for more information.

### Traces

**Exported fields**

| Field | Description | Type | Unit |
|---|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |  |
| agent.activation_method | The way the agent is installed / used. | keyword |  |
| agent.ephemeral_id | Ephemeral identifier of this agent (if one exists). This id normally changes across restarts, but `agent.id` does not. | keyword |  |
| agent.name | Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from. | keyword |  |
| agent.version | Version of the agent. | keyword |  |
| child.id | The ID(s) of the child event(s). | keyword |  |
| client.domain | The domain name of the client system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |  |
| client.geo.city_name | City name. | keyword |  |
| client.geo.continent_name | Name of the continent. | keyword |  |
| client.geo.country_iso_code | Country ISO code. | keyword |  |
| client.geo.country_name | Country name. | keyword |  |
| client.geo.location | Longitude and latitude. | geo_point |  |
| client.geo.region_iso_code | Region ISO code. | keyword |  |
| client.geo.region_name | Region name. | keyword |  |
| client.ip | IP address of the client (IPv4 or IPv6). | ip |  |
| client.port | Port of the client. | long |  |
| cloud.account.id | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier. | keyword |  |
| cloud.account.name | The cloud account name or alias used to identify different entities in a multi-tenant environment. Examples: AWS account name, Google Cloud ORG display name. | keyword |  |
| cloud.availability_zone | Availability zone in which this host, resource, or service is located. | keyword |  |
| cloud.instance.id | Instance ID of the host machine. | keyword |  |
| cloud.instance.name | Instance name of the host machine. | keyword |  |
| cloud.machine.type | Machine type of the host machine. | keyword |  |
| cloud.origin.account.id | The cloud account or organization id used to identify different entities in a multi-tenant environment. | keyword |  |
| cloud.origin.provider | Name of the cloud provider. | keyword |  |
| cloud.origin.region | Region in which this host, resource, or service is located. | keyword |  |
| cloud.origin.service.name | The cloud service name is intended to distinguish services running on different platforms within a provider. | keyword |  |
| cloud.project.id | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id. | keyword |  |
| cloud.project.name | The cloud project name. Examples: Google Cloud Project name, Azure Project name. | keyword |  |
| cloud.provider | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean. | keyword |  |
| cloud.region | Region in which this host, resource, or service is located. | keyword |  |
| cloud.service.name | The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server. Examples: app engine, app service, cloud run, fargate, lambda. | keyword |  |
| container.id | Unique container id. | keyword |  |
| data_stream.dataset | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   \* Must not contain `-`   \* No longer than 100 characters | constant_keyword |  |
| data_stream.namespace | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   \* Must not contain `-`   \* No longer than 100 characters | constant_keyword |  |
| data_stream.type | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future. | constant_keyword |  |
| destination.address | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is. | keyword |  |
| destination.ip | IP address of the destination (IPv4 or IPv6). | ip |  |
| destination.port | Port of the destination. | long |  |
| device.id | The unique identifier of a device. The identifier must not change across application sessions but stay fixex for an instance of a (mobile) device.  On iOS, this value must be equal to the vendor identifier (https://developer.apple.com/documentation/uikit/uidevice/1620059-identifierforvendor). On Android, this value must be equal to the Firebase Installation ID or a globally unique UUID which is persisted across sessions in your application. For GDPR and data protection law reasons this identifier should not carry information that would allow to identify a user. | keyword |  |
| device.manufacturer | The vendor name of the device manufacturer. | keyword |  |
| device.model.identifier | The machine readable identifier of the device model. | keyword |  |
| device.model.name | The human readable marketing name of the device model. | keyword |  |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |  |
| event.success_count | Numeric value of event.outcome: 1 for 'success', 0 for 'failure', and null for 'unknown'. | byte |  |
| faas.coldstart | Boolean indicating whether the function invocation was a coldstart or not. | boolean |  |
| faas.execution | Request ID of the function invocation. | keyword |  |
| faas.id | A unique identifier of the invoked serverless function. | keyword |  |
| faas.name | The lambda function name. | keyword |  |
| faas.trigger.request_id | The ID of the origin trigger request. | keyword |  |
| faas.trigger.type | The trigger type. | keyword |  |
| faas.version | The lambda function version. | keyword |  |
| host.architecture | Operating system architecture. | keyword |  |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |  |
| host.ip | Host ip addresses. | ip |  |
| host.name | Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use. | keyword |  |
| host.os.full | Operating system name, including the version or code name. | keyword |  |
| host.os.full.text | Multi-field of `host.os.full`. | match_only_text |  |
| host.os.name | Operating system name, without the version. | keyword |  |
| host.os.name.text | Multi-field of `host.os.name`. | match_only_text |  |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |  |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |  |
| host.os.version | Operating system version as a raw string. | keyword |  |
| http.request.body | The original body of the monitored HTTP request. | flattened |  |
| http.request.cookies | The cookies of the monitored HTTP request. | object |  |
| http.request.env | The CGI-like environment variables of the monitored HTTP request. | object |  |
| http.request.headers | The canonical headers of the monitored HTTP request. | object |  |
| http.request.id | A unique identifier for each HTTP request to correlate logs between clients and servers in transactions. The id may be contained in a non-standard HTTP header, such as `X-Request-ID` or `X-Correlation-ID`. | keyword |  |
| http.request.method | HTTP request method. The value should retain its casing from the original event. For example, `GET`, `get`, and `GeT` are all considered valid values for this field. | keyword |  |
| http.request.referrer | Referrer for this HTTP request. | keyword |  |
| http.response.decoded_body_size | The size (in octets) received from the fetch (HTTP or cache) of the message body, after removing any applied content-codings. If the resource is retrieved from an application cache or local resources, it returns the size of the payload after removing any applied content-codings. | long | byte |
| http.response.encoded_body_size | The size (in octets) received from the fetch (HTTP or cache), of the payload body, before removing any applied content-codings. | long | byte |
| http.response.finished | Used by the Node agent to indicate when in the response life cycle an error has occurred. | boolean |  |
| http.response.headers | The canonical headers of the monitored HTTP response. | object |  |
| http.response.headers_sent | Used by the Node agent to indicate whether HTTP response headers were sent. | boolean |  |
| http.response.status_code | HTTP response status code. | long |  |
| http.response.transfer_size | The size (in octets) of the fetched resource. The size includes the response header fields plus the response payload body (as defined by RFC7230). | long | byte |
| http.version | HTTP version. | keyword |  |
| kubernetes.namespace | Kubernetes namespace | keyword |  |
| kubernetes.node.name | Kubernetes node name | keyword |  |
| kubernetes.pod.name | Kubernetes pod name | keyword |  |
| kubernetes.pod.uid | Kubernetes Pod UID | keyword |  |
| labels | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as keyword. Example: `docker` and `k8s` labels. | object |  |
| network.carrier.icc | ISO country code, eg. US | keyword |  |
| network.carrier.mcc | Mobile country code | keyword |  |
| network.carrier.mnc | Mobile network code | keyword |  |
| network.carrier.name | Carrier name, eg. Vodafone, T-Mobile, etc. | keyword |  |
| network.connection.subtype | Detailed network connection sub-type, e.g. "LTE", "CDMA" | keyword |  |
| network.connection.type | Network connection type, eg. "wifi", "cell" | keyword |  |
| numeric_labels | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as scaled_float. | object |  |
| observer.hostname | Hostname of the observer. | keyword |  |
| observer.name | Custom name of the observer. This is a name that can be given to an observer. This can be helpful for example if multiple firewalls of the same model are used in an organization. If no custom name is needed, the field can be left empty. | keyword |  |
| observer.type | The type of the observer the data is coming from. There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`. | keyword |  |
| observer.version | Observer version. | keyword |  |
| parent.id | The ID of the parent event. | keyword |  |
| process.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |  |
| process.parent.pid | Process id. | long |  |
| process.pid | Process id. | long |  |
| process.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |  |
| process.title.text | Multi-field of `process.title`. | match_only_text |  |
| processor.event | Processor event, either "transaction" or "span". | keyword |  |
| service.environment | Identifies the environment where the service is running. If the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment. | keyword |  |
| service.framework.name | Name of the framework used. | keyword |  |
| service.framework.version | Version of the framework used. | keyword |  |
| service.language.name | Name of the programming language used. | keyword |  |
| service.language.version | Version of the programming language used. | keyword |  |
| service.name | Name of the service data is collected from. The name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name. In the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified. | keyword |  |
| service.node.name | Name of a service node. This allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service. In the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set. | keyword |  |
| service.origin.id | Immutable id of the service emitting this event. | keyword |  |
| service.origin.name | Immutable name of the service emitting this event. | keyword |  |
| service.origin.version | The version of the service the data was collected from. | keyword |  |
| service.runtime.name | Name of the runtime used. | keyword |  |
| service.runtime.version | Version of the runtime used. | keyword |  |
| service.target.name | Target service for which data is collected. | keyword |  |
| service.target.type | Type of the target service for which data is collected | keyword |  |
| service.version | Version of the service the data was collected from. This allows to look at a data set only for a specific version of a service. | keyword |  |
| session.id | The ID of the session to which the event belongs. | keyword |  |
| session.sequence | The sequence number of the event within the session to which the event belongs. | long |  |
| source.domain | The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |  |
| source.ip | IP address of the source (IPv4 or IPv6). | ip |  |
| source.nat.ip | Translated ip of source based NAT sessions (e.g. internal client to internet) Typically connections traversing load balancers, firewalls, or routers. | ip |  |
| source.nat.port | Translated port of source based NAT sessions. (e.g. internal client to internet) Typically used with load balancers, firewalls, or routers. | long |  |
| source.port | Port of the source. | long |  |
| span.action | The specific kind of event within the sub-type represented by the span (e.g. query, connect) | keyword |  |
| span.composite.compression_strategy | The compression strategy that was used. | keyword |  |
| span.composite.count | Number of compressed spans the composite span represents. | long |  |
| span.composite.sum.us | Sum of the durations of the compressed spans, in microseconds. | long |  |
| span.db.instance | Database instance. | keyword |  |
| span.db.link | Database link. | keyword |  |
| span.db.rows_affected | Number of rows affected by the database statement. | long |  |
| span.db.statement | Database statement. | keyword |  |
| span.db.type | Database type. | keyword |  |
| span.db.user.name | Database username. | keyword |  |
| span.destination.service.name | Identifier for the destination service (e.g. 'http://elastic.co', 'elasticsearch', 'rabbitmq') DEPRECATED: this field will be removed in a future release | keyword |  |
| span.destination.service.resource | Identifier for the destination service resource being operated on (e.g. 'http://elastic.co:80', 'elasticsearch', 'rabbitmq/queue_name') | keyword |  |
| span.destination.service.type | Type of the destination service (e.g. 'db', 'elasticsearch'). Should typically be the same as span.type. DEPRECATED: this field will be removed in a future release | keyword |  |
| span.duration.us | Duration of the span, in microseconds. | long |  |
| span.id | Unique identifier of the span within the scope of its trace. A span represents an operation within a transaction, such as a request to another service, or a database query. | keyword |  |
| span.kind | "The kind of span: CLIENT, SERVER, PRODUCER, CONSUMER, or INTERNAL." | keyword |  |
| span.links.span.id | Unique identifier of the linked span. | keyword |  |
| span.links.trace.id | Unique identifier of the linked trace. | keyword |  |
| span.message.age.ms | Age of a message in milliseconds. | long |  |
| span.message.body | The message body | keyword |  |
| span.message.headers | The message headers | object |  |
| span.message.queue.name | Name of the message queue or topic where the message is published or received. | keyword |  |
| span.message.routing_key | The message routing key | keyword |  |
| span.name | Generic designation of a span in the scope of a transaction. | keyword |  |
| span.representative_count | The approximate number of spans represented, based on the inverse sampling rate. This will only be set when the sampling rate is known. | scaled_float |  |
| span.stacktrace | Stacktrace identifying the instrumented source code corresponding to the span. | flattened |  |
| span.subtype | A further sub-division of the type (e.g. postgresql, elasticsearch) | keyword |  |
| span.sync | Indicates whether the span was executed synchronously or asynchronously. | boolean |  |
| span.type | Keyword of specific relevance in the service's domain (eg: 'db.postgresql.query', 'template.erb', 'cache', etc). | keyword |  |
| timestamp.us | Timestamp of the event in microseconds since Unix epoch. | long |  |
| trace.id | Unique identifier of the trace. A trace groups multiple events like transactions that belong together. For example, a user request handled by multiple inter-connected services. | keyword |  |
| transaction.custom | Custom transaction context. | flattened |  |
| transaction.duration.us | Total duration of this transaction, in microseconds. | long |  |
| transaction.experience.cls | The Cumulative Layout Shift metric | scaled_float |  |
| transaction.experience.fid | The First Input Delay metric | scaled_float |  |
| transaction.experience.longtask.count | The total number of of longtasks | long |  |
| transaction.experience.longtask.max | The max longtask duration | scaled_float |  |
| transaction.experience.longtask.sum | The sum of longtask durations | scaled_float |  |
| transaction.experience.tbt | The Total Blocking Time metric | scaled_float |  |
| transaction.id | Unique identifier of the transaction within the scope of its trace. A transaction is the highest level of work measured within a service, such as a request to a server. | keyword |  |
| transaction.marks | A user-defined mapping of groups of marks in milliseconds. | object |  |
| transaction.message.age.ms | Age of a message in milliseconds. | long |  |
| transaction.message.body | The message body | keyword |  |
| transaction.message.headers | The message headers | object |  |
| transaction.message.queue.name | Name of the message queue or topic where the message is published or received. | keyword |  |
| transaction.message.routing_key | The message routing key | keyword |  |
| transaction.name | Generic designation of a transaction in the scope of a single service (eg. 'GET /users/:id'). | keyword |  |
| transaction.name.text | Multi-field of `transaction.name`. | text |  |
| transaction.representative_count | The approximate number of transactions represented, based on the inverse sampling rate. | scaled_float |  |
| transaction.result | The result of the transaction. HTTP status code for HTTP-related transactions. | keyword |  |
| transaction.sampled | Transactions that are 'sampled' will include all available information. Transactions that are not sampled will not have spans or context. | boolean |  |
| transaction.span_count.dropped | The total amount of dropped spans for this transaction. | long |  |
| transaction.span_count.started | The total amount of started spans for this transaction. | long |  |
| transaction.type | Keyword of specific relevance in the service's domain (eg. 'request', 'backgroundjob', etc) | keyword |  |
| url.domain | Domain of the url, such as "www.elastic.co". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field. | keyword |  |
| url.fragment | Portion of the url after the `#`, such as "top". The `#` is not part of the fragment. | keyword |  |
| url.full | If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source. | wildcard |  |
| url.full.text | Multi-field of `url.full`. | match_only_text |  |
| url.original | Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not. | wildcard |  |
| url.original.text | Multi-field of `url.original`. | match_only_text |  |
| url.path | Path of the request, such as "/search". | wildcard |  |
| url.port | Port of the request, such as 443. | long |  |
| url.query | The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases. | keyword |  |
| url.scheme | Scheme of the request, such as "https". Note: The `:` is not part of the scheme. | keyword |  |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |  |
| user.email | User email address. | keyword |  |
| user.id | Unique identifier of the user. | keyword |  |
| user.name | Short name or login of the user. | keyword |  |
| user.name.text | Multi-field of `user.name`. | match_only_text |  |
| user_agent.device.name | Name of the device. | keyword |  |
| user_agent.name | Name of the user agent. | keyword |  |
| user_agent.original | Unparsed user_agent string. | keyword |  |
| user_agent.original.text | Multi-field of `user_agent.original`. | match_only_text |  |
| user_agent.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |  |
| user_agent.os.full | Operating system name, including the version or code name. | keyword |  |
| user_agent.os.full.text | Multi-field of `user_agent.os.full`. | match_only_text |  |
| user_agent.os.kernel | Operating system kernel version as a raw string. | keyword |  |
| user_agent.os.name | Operating system name, without the version. | keyword |  |
| user_agent.os.name.text | Multi-field of `user_agent.os.name`. | match_only_text |  |
| user_agent.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |  |
| user_agent.os.version | Operating system version as a raw string. | keyword |  |
| user_agent.version | Version of the user agent. | keyword |  |


### Application Metrics

**Exported fields**

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| agent.activation_method | The way the agent is installed / used. | keyword |
| agent.ephemeral_id | Ephemeral identifier of this agent (if one exists). This id normally changes across restarts, but `agent.id` does not. | keyword |
| agent.name | Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from. | keyword |
| agent.version | Version of the agent. | keyword |
| client.domain | The domain name of the client system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |
| client.geo.city_name | City name. | keyword |
| client.geo.continent_name | Name of the continent. | keyword |
| client.geo.country_iso_code | Country ISO code. | keyword |
| client.geo.country_name | Country name. | keyword |
| client.geo.location | Longitude and latitude. | geo_point |
| client.geo.region_iso_code | Region ISO code. | keyword |
| client.geo.region_name | Region name. | keyword |
| client.ip | IP address of the client (IPv4 or IPv6). | ip |
| client.port | Port of the client. | long |
| cloud.account.id | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier. | keyword |
| cloud.account.name | The cloud account name or alias used to identify different entities in a multi-tenant environment. Examples: AWS account name, Google Cloud ORG display name. | keyword |
| cloud.availability_zone | Availability zone in which this host, resource, or service is located. | keyword |
| cloud.instance.id | Instance ID of the host machine. | keyword |
| cloud.instance.name | Instance name of the host machine. | keyword |
| cloud.machine.type | Machine type of the host machine. | keyword |
| cloud.project.id | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id. | keyword |
| cloud.project.name | The cloud project name. Examples: Google Cloud Project name, Azure Project name. | keyword |
| cloud.provider | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean. | keyword |
| cloud.region | Region in which this host, resource, or service is located. | keyword |
| cloud.service.name | The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server. Examples: app engine, app service, cloud run, fargate, lambda. | keyword |
| container.id | Unique container id. | keyword |
| data_stream.dataset | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   \* Must not contain `-`   \* No longer than 100 characters | constant_keyword |
| data_stream.namespace | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   \* Must not contain `-`   \* No longer than 100 characters | constant_keyword |
| data_stream.type | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future. | constant_keyword |
| destination.address | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is. | keyword |
| destination.ip | IP address of the destination (IPv4 or IPv6). | ip |
| destination.port | Port of the destination. | long |
| device.id | The unique identifier of a device. The identifier must not change across application sessions but stay fixex for an instance of a (mobile) device.  On iOS, this value must be equal to the vendor identifier (https://developer.apple.com/documentation/uikit/uidevice/1620059-identifierforvendor). On Android, this value must be equal to the Firebase Installation ID or a globally unique UUID which is persisted across sessions in your application. For GDPR and data protection law reasons this identifier should not carry information that would allow to identify a user. | keyword |
| device.manufacturer | The vendor name of the device manufacturer. | keyword |
| device.model.identifier | The machine readable identifier of the device model. | keyword |
| device.model.name | The human readable marketing name of the device model. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.ip | Host ip addresses. | ip |
| host.name | Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use. | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.full.text | Multi-field of `host.os.full`. | match_only_text |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.name.text | Multi-field of `host.os.name`. | match_only_text |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| kubernetes.namespace | Kubernetes namespace | keyword |
| kubernetes.node.name | Kubernetes node name | keyword |
| kubernetes.pod.name | Kubernetes pod name | keyword |
| kubernetes.pod.uid | Kubernetes Pod UID | keyword |
| labels | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as keyword. Example: `docker` and `k8s` labels. | object |
| metricset.name | Name of the set of metrics. | keyword |
| network.connection.type | Network connection type, eg. "wifi", "cell" | keyword |
| numeric_labels | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as scaled_float. | object |
| observer.hostname | Hostname of the observer. | keyword |
| observer.name | Custom name of the observer. This is a name that can be given to an observer. This can be helpful for example if multiple firewalls of the same model are used in an organization. If no custom name is needed, the field can be left empty. | keyword |
| observer.type | The type of the observer the data is coming from. There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`. | keyword |
| observer.version | Observer version. | keyword |
| process.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.parent.pid | Process id. | long |
| process.pid | Process id. | long |
| process.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |
| process.title.text | Multi-field of `process.title`. | match_only_text |
| processor.event | Processor event. | constant_keyword |
| service.environment | Identifies the environment where the service is running. If the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment. | keyword |
| service.framework.name | Name of the framework used. | keyword |
| service.framework.version | Version of the framework used. | keyword |
| service.language.name | Name of the programming language used. | keyword |
| service.language.version | Version of the programming language used. | keyword |
| service.name | Name of the service data is collected from. The name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name. In the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified. | keyword |
| service.node.name | Name of a service node. This allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service. In the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set. | keyword |
| service.runtime.name | Name of the runtime used. | keyword |
| service.runtime.version | Version of the runtime used. | keyword |
| service.version | Version of the service the data was collected from. This allows to look at a data set only for a specific version of a service. | keyword |
| source.domain | The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |
| source.ip | IP address of the source (IPv4 or IPv6). | ip |
| source.nat.ip | Translated ip of source based NAT sessions (e.g. internal client to internet) Typically connections traversing load balancers, firewalls, or routers. | ip |
| source.nat.port | Translated port of source based NAT sessions. (e.g. internal client to internet) Typically used with load balancers, firewalls, or routers. | long |
| source.port | Port of the source. | long |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.email | User email address. | keyword |
| user.id | Unique identifier of the user. | keyword |
| user.name | Short name or login of the user. | keyword |
| user.name.text | Multi-field of `user.name`. | match_only_text |
| user_agent.device.name | Name of the device. | keyword |
| user_agent.name | Name of the user agent. | keyword |
| user_agent.original | Unparsed user_agent string. | keyword |
| user_agent.original.text | Multi-field of `user_agent.original`. | match_only_text |
| user_agent.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| user_agent.os.full | Operating system name, including the version or code name. | keyword |
| user_agent.os.full.text | Multi-field of `user_agent.os.full`. | match_only_text |
| user_agent.os.kernel | Operating system kernel version as a raw string. | keyword |
| user_agent.os.name | Operating system name, without the version. | keyword |
| user_agent.os.name.text | Multi-field of `user_agent.os.name`. | match_only_text |
| user_agent.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| user_agent.os.version | Operating system version as a raw string. | keyword |
| user_agent.version | Version of the user agent. | keyword |


### Internal Metrics

**Exported fields**

| Field | Description | Type | Unit | Metric Type |
|---|---|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |  |  |
| agent.activation_method | The way the agent is installed / used. | keyword |  |  |
| agent.background.cpu.overhead.pct | The share of process CPU usage caused by background tasks running in the agent. It ranges from 0 to 100%. | scaled_float | percent | gauge |
| agent.background.cpu.total.pct | The total CPU usage caused by background tasks running in the agent. It ranges from 0 to 100%. | scaled_float | percent | gauge |
| agent.background.memory.allocation.bytes | The number of bytes allocated by background tasks running in the agent. | long | byte |  |
| agent.ephemeral_id | Ephemeral identifier of this agent (if one exists). This id normally changes across restarts, but `agent.id` does not. | keyword |  |  |
| agent.events.dropped | The number of events which could not be sent from agents to the APM server, e.g. due to a full queue or an error. | long |  |  |
| agent.events.queue.max_size.pct | The maximum size of the agent's internal event reporting queue since the last metrics report. | scaled_float | percent | gauge |
| agent.events.queue.min_size.pct | The minimum size of the agent's internal event reporting queue since the last metrics report. | scaled_float | percent | gauge |
| agent.events.requests.bytes | The number of bytes attempted to send (successful and failed) from agents to the APM server to report data. | long | byte |  |
| agent.events.requests.count | The number of requests made (successful and failed) from agents to the APM server to report data. | long |  |  |
| agent.events.total | The total number of events attempted to report to the APM server per agent. | long |  |  |
| agent.name | Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from. | keyword |  |  |
| agent.version | Version of the agent. | keyword |  |  |
| agent_config_applied | Value for agent_config_applied | long |  |  |
| client.domain | The domain name of the client system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |  |  |
| client.geo.city_name | City name. | keyword |  |  |
| client.geo.continent_name | Name of the continent. | keyword |  |  |
| client.geo.country_iso_code | Country ISO code. | keyword |  |  |
| client.geo.country_name | Country name. | keyword |  |  |
| client.geo.location | Longitude and latitude. | geo_point |  |  |
| client.geo.region_iso_code | Region ISO code. | keyword |  |  |
| client.geo.region_name | Region name. | keyword |  |  |
| client.ip | IP address of the client (IPv4 or IPv6). | ip |  |  |
| client.port | Port of the client. | long |  |  |
| cloud.account.id | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier. | keyword |  |  |
| cloud.account.name | The cloud account name or alias used to identify different entities in a multi-tenant environment. Examples: AWS account name, Google Cloud ORG display name. | keyword |  |  |
| cloud.availability_zone | Availability zone in which this host, resource, or service is located. | keyword |  |  |
| cloud.instance.id | Instance ID of the host machine. | keyword |  |  |
| cloud.instance.name | Instance name of the host machine. | keyword |  |  |
| cloud.machine.type | Machine type of the host machine. | keyword |  |  |
| cloud.project.id | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id. | keyword |  |  |
| cloud.project.name | The cloud project name. Examples: Google Cloud Project name, Azure Project name. | keyword |  |  |
| cloud.provider | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean. | keyword |  |  |
| cloud.region | Region in which this host, resource, or service is located. | keyword |  |  |
| cloud.service.name | The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server. Examples: app engine, app service, cloud run, fargate, lambda. | keyword |  |  |
| clr.gc.count | The total number of GC collections that have occurred. | long |  | counter |
| clr.gc.gen0size | The size of the generation 0 heap. | long | byte | gauge |
| clr.gc.gen1size | The size of the generation 1 heap. | long | byte | gauge |
| clr.gc.gen2size | The size of the generation 2 heap. | long | byte | gauge |
| clr.gc.gen3size | The size of the generation 3 heap - also known as Large Object Heap (LOH). | long | byte | gauge |
| clr.gc.time | The approximate accumulated collection elapsed time in milliseconds. | long | ms | counter |
| container.id | Unique container id. | keyword |  |  |
| data_stream.dataset | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   \* Must not contain `-`   \* No longer than 100 characters | constant_keyword |  |  |
| data_stream.namespace | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   \* Must not contain `-`   \* No longer than 100 characters | constant_keyword |  |  |
| data_stream.type | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future. | constant_keyword |  |  |
| destination.address | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is. | keyword |  |  |
| destination.ip | IP address of the destination (IPv4 or IPv6). | ip |  |  |
| destination.port | Port of the destination. | long |  |  |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |  |  |
| faas.billed_duration | The number of milliseconds for which the FaaS end user is billed. | long | ms | counter |
| faas.coldstart | Boolean indicating whether the function invocation was a coldstart or not. | boolean |  |  |
| faas.coldstart_duration | The number of milliseconds elapsed during cold start. | float | ms | counter |
| faas.duration | The total number of milliseconds elapsed during the execution of the FaaS invocation. | float | ms | counter |
| faas.execution | Request ID of the function invocation. | keyword |  |  |
| faas.id | A unique identifier of the invoked serverless function. | keyword |  |  |
| faas.name | The lambda function name. | keyword |  |  |
| faas.timeout | The FaaS invocation timeout, expressed in milliseconds. | long | ms | counter |
| faas.trigger.request_id | The ID of the origin trigger request. | keyword |  |  |
| faas.trigger.type | The trigger type. | keyword |  |  |
| faas.version | The lambda function version. | keyword |  |  |
| golang.goroutines | The number of goroutines that currently exist. | long |  | counter |
| golang.heap.allocations.active | Bytes in non-idle spans. | long | byte | gauge |
| golang.heap.allocations.allocated | Bytes allocated and not yet freed (same as Alloc from runtime.MemStats). | long | byte | gauge |
| golang.heap.allocations.frees | The number of frees. | long |  | counter |
| golang.heap.allocations.idle | Bytes in idle spans. | long | byte | gauge |
| golang.heap.allocations.mallocs | The number of mallocs. | long |  | counter |
| golang.heap.allocations.objects | The total number of allocated objects. | long |  | counter |
| golang.heap.allocations.total | Bytes allocated (even if freed) throughout the lifetime. | long | byte | counter |
| golang.heap.gc.cpu_fraction | Fraction of CPU time used by garbage collection. | scaled_float | percent | gauge |
| golang.heap.gc.next_gc_limit | Target heap size of the next garbage collection cycle. | long | byte | gauge |
| golang.heap.gc.total_count | The total number of garbage collections. | long |  | counter |
| golang.heap.gc.total_pause.ns | The total garbage collection duration in nanoseconds. | long | nanos | counter |
| golang.heap.system.obtained | Via HeapSys from runtime.MemStats, bytes obtained from system. heap_sys = heap_idle + heap_inuse. | long | byte | gauge |
| golang.heap.system.released | Bytes released to the OS. | long | byte | gauge |
| golang.heap.system.stack | Bytes of stack memory obtained from the OS. | long | byte | gauge |
| golang.heap.system.total | Total bytes obtained from system (sum of XxxSys from runtime.MemStats). | long | byte | gauge |
| host.architecture | Operating system architecture. | keyword |  |  |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |  |  |
| host.ip | Host ip addresses. | ip |  |  |
| host.name | Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use. | keyword |  |  |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |  |  |
| jvm.fd.max |  | long |  | gauge |
| jvm.fd.used |  | long |  | gauge |
| jvm.gc.alloc |  | long | byte | gauge |
| jvm.gc.count |  | long |  | gauge |
| jvm.gc.time |  | long | ms | gauge |
| jvm.memory.heap.committed |  | long | byte | gauge |
| jvm.memory.heap.max |  | long | byte | gauge |
| jvm.memory.heap.pool.committed |  | long | byte | gauge |
| jvm.memory.heap.pool.max |  | long | byte | gauge |
| jvm.memory.heap.pool.used |  | long | byte | gauge |
| jvm.memory.heap.used |  | long | byte | gauge |
| jvm.memory.non_heap.committed |  | long | byte | gauge |
| jvm.memory.non_heap.max |  | long | byte | gauge |
| jvm.memory.non_heap.pool.committed |  | long | byte | gauge |
| jvm.memory.non_heap.pool.max |  | long | byte | gauge |
| jvm.memory.non_heap.pool.used |  | long | byte | gauge |
| jvm.memory.non_heap.used |  | long | byte | gauge |
| jvm.thread.count |  | long |  | gauge |
| kubernetes.namespace | Kubernetes namespace | keyword |  |  |
| kubernetes.node.name | Kubernetes node name | keyword |  |  |
| kubernetes.pod.name | Kubernetes pod name | keyword |  |  |
| kubernetes.pod.uid | Kubernetes Pod UID | keyword |  |  |
| labels | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as keyword. Example: `docker` and `k8s` labels. | object |  |  |
| metricset.name | Name of the set of metrics. | keyword |  |  |
| network.connection.type | Network connection type, eg. "wifi", "cell" | keyword |  |  |
| nodejs.eventloop.delay.avg.ms |  | scaled_float | ms | gauge |
| nodejs.handles.active |  | long |  | gauge |
| nodejs.memory.arrayBuffers.bytes |  | long | byte | gauge |
| nodejs.memory.external.bytes |  | long | byte | gauge |
| nodejs.memory.heap.allocated.bytes |  | long | byte | gauge |
| nodejs.memory.heap.used.bytes |  | long | byte | gauge |
| nodejs.requests.active |  | long |  | gauge |
| numeric_labels | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as scaled_float. | object |  |  |
| observer.hostname | Hostname of the observer. | keyword |  |  |
| observer.name | Custom name of the observer. This is a name that can be given to an observer. This can be helpful for example if multiple firewalls of the same model are used in an organization. If no custom name is needed, the field can be left empty. | keyword |  |  |
| observer.type | The type of the observer the data is coming from. There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`. | keyword |  |  |
| observer.version | Observer version. | keyword |  |  |
| process.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |  |  |
| process.parent.pid | Process id. | long |  |  |
| process.pid | Process id. | long |  |  |
| process.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |  |  |
| process.title.text | Multi-field of `process.title`. | match_only_text |  |  |
| processor.event | Processor event. | constant_keyword |  |  |
| ruby.gc.count |  | long |  | counter |
| ruby.gc.time |  | scaled_float |  | counter |
| ruby.heap.allocations.total |  | long |  | gauge |
| ruby.heap.slots.free |  | long |  | gauge |
| ruby.heap.slots.live |  | long |  | gauge |
| ruby.threads |  | long |  | gauge |
| service.environment | Identifies the environment where the service is running. If the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment. | keyword |  |  |
| service.framework.name | Name of the framework used. | keyword |  |  |
| service.framework.version | Version of the framework used. | keyword |  |  |
| service.language.name | Name of the programming language used. | keyword |  |  |
| service.language.version | Version of the programming language used. | keyword |  |  |
| service.name | Name of the service data is collected from. The name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name. In the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified. | keyword |  |  |
| service.node.name | Name of a service node. This allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service. In the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set. | keyword |  |  |
| service.runtime.name | Name of the runtime used. | keyword |  |  |
| service.runtime.version | Version of the runtime used. | keyword |  |  |
| service.target.name | Target service for which data is collected. | keyword |  |  |
| service.target.type | Type of the target service for which data is collected | keyword |  |  |
| service.version | Version of the service the data was collected from. This allows to look at a data set only for a specific version of a service. | keyword |  |  |
| source.domain | The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |  |  |
| source.ip | IP address of the source (IPv4 or IPv6). | ip |  |  |
| source.nat.ip | Translated ip of source based NAT sessions (e.g. internal client to internet) Typically connections traversing load balancers, firewalls, or routers. | ip |  |  |
| source.nat.port | Translated port of source based NAT sessions. (e.g. internal client to internet) Typically used with load balancers, firewalls, or routers. | long |  |  |
| source.port | Port of the source. | long |  |  |
| span.destination.service.resource | Identifier for the destination service resource being operated on (e.g. 'http://elastic.co:80', 'elasticsearch', 'rabbitmq/queue_name') | keyword |  |  |
| span.destination.service.response_time.count | Number of aggregated outgoing requests. | long |  |  |
| span.destination.service.response_time.sum.us | Aggregated duration of outgoing requests, in microseconds. | long | micros |  |
| span.name | Generic designation of a span in the scope of a transaction. | keyword |  |  |
| span.self_time.count | Number of aggregated spans. | long |  |  |
| span.self_time.sum.us | Aggregated span duration, excluding the time periods where a direct child was running, in microseconds. | long | micros |  |
| span.subtype | A further sub-division of the type (e.g. postgresql, elasticsearch) | keyword |  |  |
| span.type | Keyword of specific relevance in the service's domain (eg: 'db.postgresql.query', 'template.erb', 'cache', etc). | keyword |  |  |
| system.cpu.total.norm.pct | The percentage of CPU time spent by the process since the last event. This value is normalized by the number of CPU cores and it ranges from 0 to 100%. | scaled_float | percent | gauge |
| system.memory.actual.free | Actual free memory in bytes. It is calculated based on the OS. On Linux it consists of the free memory plus caches and buffers. On OSX it is a sum of free memory and the inactive memory. On Windows, it is equal to `system.memory.free`. | long | byte | gauge |
| system.memory.total | Total memory. | long | byte | gauge |
| system.process.cgroup.cpu.cfs.period.us | CFS period in microseconds. | long | micros | counter |
| system.process.cgroup.cpu.cfs.quota.us | CFS quota in microseconds. | long | micros | counter |
| system.process.cgroup.cpu.stats.periods | Number of periods seen by the CPU. | long |  | counter |
| system.process.cgroup.cpu.stats.throttled.ns | Nanoseconds spent throttled seen by the CPU. | long | nanos | counter |
| system.process.cgroup.cpu.stats.throttled.periods | Number of throttled periods seen by the CPU. | long |  | counter |
| system.process.cgroup.cpuacct.total.ns | Total CPU time for the current cgroup CPU in nanoseconds. | long | nanos | counter |
| system.process.cgroup.memory.mem.limit.bytes | Memory limit for the current cgroup slice. | long | byte | gauge |
| system.process.cgroup.memory.mem.usage.bytes | Memory usage by the current cgroup slice. | long | byte | gauge |
| system.process.cgroup.memory.stats.inactive_file.bytes | File-backed memory on inactive LRU list, in bytes. | long | byte | gauge |
| system.process.cpu.system.norm.pct | The percentage of CPU time spent by the process executing kernel code since the last event. This value is normalized by the number of CPU cores and it ranges from 0 to 100%. | scaled_float | percent | gauge |
| system.process.cpu.total.norm.pct | The percentage of CPU time spent by the process since the last event. This value is normalized by the number of CPU cores and it ranges from 0 to 100%. | scaled_float | percent | gauge |
| system.process.cpu.user.norm.pct | The percentage of CPU time spent by the process executing application code since the last event. This value is normalized by the number of CPU cores and it ranges from 0 to 100%. | scaled_float | percent | gauge |
| system.process.memory.rss.bytes | The Resident Set Size. The amount of memory the process occupied in main memory (RAM). | long | byte | gauge |
| system.process.memory.size | The total virtual memory the process has. | long | byte | gauge |
| tags | List of keywords used to tag each event. | keyword |  |  |
| transaction.duration.histogram | Pre-aggregated histogram of transaction durations. | histogram |  |  |
| transaction.name | Generic designation of a transaction in the scope of a single service (eg. 'GET /users/:id'). | keyword |  |  |
| transaction.result | The result of the transaction. HTTP status code for HTTP-related transactions. | keyword |  |  |
| transaction.root | Identifies metrics for root transactions. This can be used for calculating metrics for traces. | boolean |  |  |
| transaction.sampled | Transactions that are 'sampled' will include all available information. Transactions that are not sampled will not have spans or context. | boolean |  |  |
| transaction.self_time.count | Number of aggregated transactions. | long |  |  |
| transaction.self_time.sum.us | Aggregated transaction duration, excluding the time periods where a direct child was running, in microseconds. | long | micros |  |
| transaction.type | Keyword of specific relevance in the service's domain (eg. 'request', 'backgroundjob', etc) | keyword |  |  |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |  |  |
| user.email | User email address. | keyword |  |  |
| user.id | Unique identifier of the user. | keyword |  |  |
| user.name | Short name or login of the user. | keyword |  |  |
| user.name.text | Multi-field of `user.name`. | match_only_text |  |  |
| user_agent.device.name | Name of the device. | keyword |  |  |
| user_agent.name | Name of the user agent. | keyword |  |  |
| user_agent.original | Unparsed user_agent string. | keyword |  |  |
| user_agent.original.text | Multi-field of `user_agent.original`. | match_only_text |  |  |
| user_agent.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |  |  |
| user_agent.os.full | Operating system name, including the version or code name. | keyword |  |  |
| user_agent.os.full.text | Multi-field of `user_agent.os.full`. | match_only_text |  |  |
| user_agent.os.kernel | Operating system kernel version as a raw string. | keyword |  |  |
| user_agent.os.name | Operating system name, without the version. | keyword |  |  |
| user_agent.os.name.text | Multi-field of `user_agent.os.name`. | match_only_text |  |  |
| user_agent.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |  |  |
| user_agent.os.version | Operating system version as a raw string. | keyword |  |  |
| user_agent.version | Version of the user agent. | keyword |  |  |


### Application errors

**Exported fields**

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| agent.activation_method | The way the agent is installed / used. | keyword |
| agent.ephemeral_id | Ephemeral identifier of this agent (if one exists). This id normally changes across restarts, but `agent.id` does not. | keyword |
| agent.name | Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from. | keyword |
| agent.version | Version of the agent. | keyword |
| client.domain | The domain name of the client system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |
| client.geo.city_name | City name. | keyword |
| client.geo.continent_name | Name of the continent. | keyword |
| client.geo.country_iso_code | Country ISO code. | keyword |
| client.geo.country_name | Country name. | keyword |
| client.geo.location | Longitude and latitude. | geo_point |
| client.geo.region_iso_code | Region ISO code. | keyword |
| client.geo.region_name | Region name. | keyword |
| client.ip | IP address of the client (IPv4 or IPv6). | ip |
| client.port | Port of the client. | long |
| cloud.account.id | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier. | keyword |
| cloud.account.name | The cloud account name or alias used to identify different entities in a multi-tenant environment. Examples: AWS account name, Google Cloud ORG display name. | keyword |
| cloud.availability_zone | Availability zone in which this host, resource, or service is located. | keyword |
| cloud.instance.id | Instance ID of the host machine. | keyword |
| cloud.instance.name | Instance name of the host machine. | keyword |
| cloud.machine.type | Machine type of the host machine. | keyword |
| cloud.project.id | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id. | keyword |
| cloud.project.name | The cloud project name. Examples: Google Cloud Project name, Azure Project name. | keyword |
| cloud.provider | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean. | keyword |
| cloud.region | Region in which this host, resource, or service is located. | keyword |
| cloud.service.name | The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server. Examples: app engine, app service, cloud run, fargate, lambda. | keyword |
| container.id | Unique container id. | keyword |
| data_stream.dataset | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   \* Must not contain `-`   \* No longer than 100 characters | constant_keyword |
| data_stream.namespace | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   \* Must not contain `-`   \* No longer than 100 characters | constant_keyword |
| data_stream.type | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future. | constant_keyword |
| destination.address | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is. | keyword |
| destination.ip | IP address of the destination (IPv4 or IPv6). | ip |
| destination.port | Port of the destination. | long |
| device.id | The unique identifier of a device. The identifier must not change across application sessions but stay fixex for an instance of a (mobile) device.  On iOS, this value must be equal to the vendor identifier (https://developer.apple.com/documentation/uikit/uidevice/1620059-identifierforvendor). On Android, this value must be equal to the Firebase Installation ID or a globally unique UUID which is persisted across sessions in your application. For GDPR and data protection law reasons this identifier should not carry information that would allow to identify a user. | keyword |
| device.manufacturer | The vendor name of the device manufacturer. | keyword |
| device.model.identifier | The machine readable identifier of the device model. | keyword |
| device.model.name | The human readable marketing name of the device model. | keyword |
| error.culprit | Function call which was the primary perpetrator of this event. | keyword |
| error.custom | Custom error context. | flattened |
| error.exception.attributes | Arbitrary attributes associated with the exception. | flattened |
| error.exception.code | The error code set when the error happened, e.g. database error code. | keyword |
| error.exception.handled | Indicator whether the error was caught somewhere in the code or not. | boolean |
| error.exception.message | The original error message. | text |
| error.exception.module | The module namespace of the original error. | keyword |
| error.exception.stacktrace | Stacktrace identifying the instrumented source code corresponding to the error. | flattened |
| error.exception.type | The type of the original error, e.g. the Java exception class name. | keyword |
| error.grouping_key | Hash of select properties of the logged error for grouping purposes. | keyword |
| error.grouping_name | Name to associate with an error group. Errors belonging to the same group (same grouping_key) may have differing values for grouping_name. Consumers may choose one arbitrarily. | keyword |
| error.id | Unique identifier for the error. | keyword |
| error.log.level | The severity of the record. | keyword |
| error.log.logger_name | The name of the logger instance used. | keyword |
| error.log.message | The additionally logged error message. | text |
| error.log.param_message | A parametrized message. E.g. 'Could not connect to %s'. The property message is still required, and should be equal to the param_message, but with placeholders replaced. In some situations the param_message is used to group errors together. | keyword |
| error.log.stacktrace | Stacktrace identifying the instrumented source code corresponding to the error. | flattened |
| error.stack_trace | The stack trace of this error in plain text. | wildcard |
| error.stack_trace.text | Multi-field of `error.stack_trace`. | match_only_text |
| error.type | The type of the error, for example the class name of the exception. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data coming in at a regular interval or not. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.ip | Host ip addresses. | ip |
| host.name | Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use. | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.full.text | Multi-field of `host.os.full`. | match_only_text |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.name.text | Multi-field of `host.os.name`. | match_only_text |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| http.request.body | The original body of the monitored HTTP request. | flattened |
| http.request.cookies | The cookies of the monitored HTTP request. | object |
| http.request.env | The CGI-like environment variables of the monitored HTTP request. | object |
| http.request.headers | The canonical headers of the monitored HTTP request. | object |
| http.request.method | HTTP request method. The value should retain its casing from the original event. For example, `GET`, `get`, and `GeT` are all considered valid values for this field. | keyword |
| http.request.referrer | Referrer for this HTTP request. | keyword |
| http.response.finished | Used by the Node agent to indicate when in the response life cycle an error has occurred. | boolean |
| http.response.headers | The canonical headers of the monitored HTTP response. | object |
| http.response.headers_sent | Used by the Node agent to indicate whether HTTP response headers were sent. | boolean |
| http.response.status_code | HTTP response status code. | long |
| http.version | HTTP version. | keyword |
| kubernetes.namespace | Kubernetes namespace | keyword |
| kubernetes.node.name | Kubernetes node name | keyword |
| kubernetes.pod.name | Kubernetes pod name | keyword |
| kubernetes.pod.uid | Kubernetes Pod UID | keyword |
| labels | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as keyword. Example: `docker` and `k8s` labels. | object |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |
| network.carrier.icc | ISO country code, eg. US | keyword |
| network.carrier.mcc | Mobile country code | keyword |
| network.carrier.mnc | Mobile network code | keyword |
| network.carrier.name | Carrier name, eg. Vodafone, T-Mobile, etc. | keyword |
| network.connection.subtype | Detailed network connection sub-type, e.g. "LTE", "CDMA" | keyword |
| network.connection.type | Network connection type, eg. "wifi", "cell" | keyword |
| numeric_labels | Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as scaled_float. | object |
| observer.hostname | Hostname of the observer. | keyword |
| observer.name | Custom name of the observer. This is a name that can be given to an observer. This can be helpful for example if multiple firewalls of the same model are used in an organization. If no custom name is needed, the field can be left empty. | keyword |
| observer.type | The type of the observer the data is coming from. There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`. | keyword |
| observer.version | Observer version. | keyword |
| parent.id | The ID of the parent event. | keyword |
| process.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.parent.pid | Process id. | long |
| process.pid | Process id. | long |
| process.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |
| process.title.text | Multi-field of `process.title`. | match_only_text |
| processor.event | Processor event. | constant_keyword |
| service.environment | Identifies the environment where the service is running. If the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment. | keyword |
| service.framework.name | Name of the framework used. | keyword |
| service.framework.version | Version of the framework used. | keyword |
| service.language.name | Name of the programming language used. | keyword |
| service.language.version | Version of the programming language used. | keyword |
| service.name | Name of the service data is collected from. The name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name. In the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified. | keyword |
| service.node.name | Name of a service node. This allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service. In the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set. | keyword |
| service.runtime.name | Name of the runtime used. | keyword |
| service.runtime.version | Version of the runtime used. | keyword |
| service.version | Version of the service the data was collected from. This allows to look at a data set only for a specific version of a service. | keyword |
| session.id | The ID of the session to which the event belongs. | keyword |
| source.domain | The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |
| source.ip | IP address of the source (IPv4 or IPv6). | ip |
| source.nat.ip | Translated ip of source based NAT sessions (e.g. internal client to internet) Typically connections traversing load balancers, firewalls, or routers. | ip |
| source.nat.port | Translated port of source based NAT sessions. (e.g. internal client to internet) Typically used with load balancers, firewalls, or routers. | long |
| source.port | Port of the source. | long |
| span.id | Unique identifier of the span within the scope of its trace. A span represents an operation within a transaction, such as a request to another service, or a database query. | keyword |
| timestamp.us | Timestamp of the event in microseconds since Unix epoch. | long |
| trace.id | Unique identifier of the trace. A trace groups multiple events like transactions that belong together. For example, a user request handled by multiple inter-connected services. | keyword |
| transaction.id | Unique identifier of the transaction within the scope of its trace. A transaction is the highest level of work measured within a service, such as a request to a server. | keyword |
| transaction.name | Keyword of designation of a transaction in the scope of a single service, eg: 'GET /users/:id'. | keyword |
| transaction.sampled | Transactions that are 'sampled' will include all available information. Transactions that are not sampled will not have spans or context. | boolean |
| transaction.type | Keyword of specific relevance in the service's domain (eg. 'request', 'backgroundjob', etc) | keyword |
| url.domain | Domain of the url, such as "www.elastic.co". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field. | keyword |
| url.fragment | Portion of the url after the `#`, such as "top". The `#` is not part of the fragment. | keyword |
| url.full | If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source. | wildcard |
| url.full.text | Multi-field of `url.full`. | match_only_text |
| url.original | Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not. | wildcard |
| url.original.text | Multi-field of `url.original`. | match_only_text |
| url.path | Path of the request, such as "/search". | wildcard |
| url.port | Port of the request, such as 443. | long |
| url.query | The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases. | keyword |
| url.scheme | Scheme of the request, such as "https". Note: The `:` is not part of the scheme. | keyword |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.email | User email address. | keyword |
| user.id | Unique identifier of the user. | keyword |
| user.name | Short name or login of the user. | keyword |
| user.name.text | Multi-field of `user.name`. | match_only_text |
| user_agent.device.name | Name of the device. | keyword |
| user_agent.name | Name of the user agent. | keyword |
| user_agent.original | Unparsed user_agent string. | keyword |
| user_agent.original.text | Multi-field of `user_agent.original`. | match_only_text |
| user_agent.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| user_agent.os.full | Operating system name, including the version or code name. | keyword |
| user_agent.os.full.text | Multi-field of `user_agent.os.full`. | match_only_text |
| user_agent.os.kernel | Operating system kernel version as a raw string. | keyword |
| user_agent.os.name | Operating system name, without the version. | keyword |
| user_agent.os.name.text | Multi-field of `user_agent.os.name`. | match_only_text |
| user_agent.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| user_agent.os.version | Operating system version as a raw string. | keyword |
| user_agent.version | Version of the user agent. | keyword |

