"use strict";
// File generated from our OpenAPI spec by Stainless.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssistantFilesPage = exports.Files = void 0;
const resource_1 = require("openai/resource");
const core_1 = require("openai/core");
const FilesAPI = __importStar(require("openai/resources/beta/assistants/files"));
const pagination_1 = require("openai/pagination");
class Files extends resource_1.APIResource {
    /**
     * Create an assistant file by attaching a
     * [File](https://platform.openai.com/docs/api-reference/files) to an
     * [assistant](https://platform.openai.com/docs/api-reference/assistants).
     */
    create(assistantId, body, options) {
        return this._client.post(`/assistants/${assistantId}/files`, {
            body,
            ...options,
            headers: { 'OpenAI-Beta': 'assistants=v1', ...options?.headers },
        });
    }
    /**
     * Retrieves an AssistantFile.
     */
    retrieve(assistantId, fileId, options) {
        return this._client.get(`/assistants/${assistantId}/files/${fileId}`, {
            ...options,
            headers: { 'OpenAI-Beta': 'assistants=v1', ...options?.headers },
        });
    }
    list(assistantId, query = {}, options) {
        if ((0, core_1.isRequestOptions)(query)) {
            return this.list(assistantId, {}, query);
        }
        return this._client.getAPIList(`/assistants/${assistantId}/files`, AssistantFilesPage, {
            query,
            ...options,
            headers: { 'OpenAI-Beta': 'assistants=v1', ...options?.headers },
        });
    }
    /**
     * Delete an assistant file.
     */
    del(assistantId, fileId, options) {
        return this._client.delete(`/assistants/${assistantId}/files/${fileId}`, {
            ...options,
            headers: { 'OpenAI-Beta': 'assistants=v1', ...options?.headers },
        });
    }
}
exports.Files = Files;
class AssistantFilesPage extends pagination_1.CursorPage {
}
exports.AssistantFilesPage = AssistantFilesPage;
(function (Files) {
    Files.AssistantFilesPage = FilesAPI.AssistantFilesPage;
})(Files = exports.Files || (exports.Files = {}));
//# sourceMappingURL=files.js.map