import { Comparators, Operators } from "../../chains/query_constructor/ir.js";
import { BasicTranslator } from "./base.js";
/**
 * Specialized translator for the Chroma vector database. It extends the
 * BasicTranslator class and translates internal query language elements
 * to valid filters. The class defines a subset of allowed logical
 * operators and comparators that can be used in the translation process.
 */
export class ChromaTranslator extends BasicTranslator {
    constructor() {
        super({
            allowedOperators: [Operators.and, Operators.or],
            allowedComparators: [
                Comparators.eq,
                Comparators.ne,
                Comparators.gt,
                Comparators.gte,
                Comparators.lt,
                Comparators.lte,
            ],
        });
    }
}
