"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getModelParamsAsync = exports.getEncodingParams = void 0;
const specialTokens_js_1 = require("./specialTokens.js");
const tokenSplitRegex = /'s|'t|'re|'ve|'m|'ll|'d| ?\p{L}+| ?\p{N}+| ?[^\s\p{L}\p{N}]+|\s+(?!\S)|\s+/gu;
function R50KBase(mergeableBytePairRanks) {
    return {
        expectedVocabularySize: 50257,
        tokenSplitRegex,
        mergeableBytePairRanks,
        specialTokenMapping: new Map([[specialTokens_js_1.EndOfText, 50256]]),
    };
}
function P50KBase(mergeableBytePairRanks) {
    return {
        expectedVocabularySize: 50281,
        tokenSplitRegex,
        mergeableBytePairRanks,
        specialTokenMapping: new Map([[specialTokens_js_1.EndOfText, 50256]]),
    };
}
function P50KEdit(mergeableBytePairRanks) {
    const specialTokenMapping = new Map([
        [specialTokens_js_1.EndOfText, 50256],
        [specialTokens_js_1.FimPrefix, 50281],
        [specialTokens_js_1.FimMiddle, 50282],
        [specialTokens_js_1.FimSuffix, 50283],
    ]);
    return {
        tokenSplitRegex,
        mergeableBytePairRanks,
        specialTokenMapping,
    };
}
function Cl100KBase(mergeableBytePairRanks) {
    const specialTokenMapping = new Map([
        [specialTokens_js_1.EndOfText, 100257],
        [specialTokens_js_1.FimPrefix, 100258],
        [specialTokens_js_1.FimMiddle, 100259],
        [specialTokens_js_1.FimSuffix, 100260],
        [specialTokens_js_1.ImStart, 100264],
        [specialTokens_js_1.ImEnd, 100265],
        [specialTokens_js_1.ImSep, 100266],
        [specialTokens_js_1.EndOfPrompt, 100276],
    ]);
    return {
        tokenSplitRegex: /(?:'s|'t|'re|'ve|'m|'ll|'d)|[^\r\n\p{L}\p{N}]?\p{L}+|\p{N}{1,3}| ?[^\s\p{L}\p{N}]+[\r\n]*|\s*[\r\n]+|\s+(?!\S)|\s+/giu,
        mergeableBytePairRanks,
        specialTokenMapping,
    };
}
function getEncodingParams(encodingName, getMergeableRanks) {
    const mergeableBytePairRanks = getMergeableRanks(encodingName);
    switch (encodingName.toLowerCase()) {
        case 'r50k_base':
            return R50KBase(mergeableBytePairRanks);
        case 'p50k_base':
            return P50KBase(mergeableBytePairRanks);
        case 'p50k_edit':
            return P50KEdit(mergeableBytePairRanks);
        case 'cl100k_base':
            return Cl100KBase(mergeableBytePairRanks);
        default:
            throw new Error(`Unknown encoding name: ${encodingName}`);
    }
}
exports.getEncodingParams = getEncodingParams;
async function getModelParamsAsync(encodingName, getMergeableRanks) {
    const mergeableBytePairRanks = await getMergeableRanks(encodingName);
    return getEncodingParams(encodingName, () => mergeableBytePairRanks);
}
exports.getModelParamsAsync = getModelParamsAsync;
//# sourceMappingURL=modelParams.js.map