"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertTokenBytePairEncodingFromTiktokenFile = exports.convertTokenBytePairEncodingFromTuples = void 0;
const rfc4648_1 = require("rfc4648");
const EncoderMap_js_1 = require("./EncoderMap.js");
function convertTokenBytePairEncodingFromTuples(tuples) {
    const encoder = tuples.flatMap(([token, rank]) => {
        if (!token || token.length === 0)
            return [];
        return [[rfc4648_1.base64.parse(token), rank]];
    });
    return new EncoderMap_js_1.EncoderMap(encoder);
}
exports.convertTokenBytePairEncodingFromTuples = convertTokenBytePairEncodingFromTuples;
function convertTokenBytePairEncodingFromTiktokenFile(input) {
    const lines = input.split('\n');
    const encoder = lines.flatMap((x) => {
        if (x.length === 0)
            return [];
        const [token, rank] = x.split(' ');
        if (!token || token.length === 0 || !rank || rank.length === 0)
            return [];
        return [[rfc4648_1.base64.parse(token), Number.parseInt(rank, 10)]];
    });
    return new EncoderMap_js_1.EncoderMap(encoder);
}
exports.convertTokenBytePairEncodingFromTiktokenFile = convertTokenBytePairEncodingFromTiktokenFile;
//# sourceMappingURL=convertTokenBytePairEncodingFromTuples.js.map