"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PagerDutyActionFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _form_errors = require("../../../../../components/form_errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PagerDutyActionFields = ({
  errors,
  hasErrors,
  action,
  editAction,
  children
}) => {
  const {
    description
  } = action;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "pagerDutyDescription",
    errorKey: "description",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && description !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.pagerDutyAction.descriptionFieldLabel', {
      defaultMessage: 'Description'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "description",
    value: description || '',
    "data-test-subj": "pagerdutyDescriptionInput",
    onChange: e => {
      editAction({
        key: 'description',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!description) {
        editAction({
          key: 'description',
          value: ''
        });
      }
    }
  })));
};
exports.PagerDutyActionFields = PagerDutyActionFields;