"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimulateWatchResultsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../../../components");
var _watch_edit_actions = require("../../watch_edit_actions");
var _watch_context = require("../../watch_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SimulateWatchResultsFlyout = ({
  executeResults,
  executeDetails,
  onCloseFlyout,
  error
}) => {
  var _details$result;
  const {
    watch
  } = (0, _react.useContext)(_watch_context.WatchContext);
  const {
    actionModes
  } = executeDetails;
  const conditionNotMetActionStatus = mode => {
    switch (mode) {
      case 'simulate':
      case 'force_simulate':
        return _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnValue.notSimulated', {
          defaultMessage: 'not simulated'
        });
      case 'execute':
      case 'force_execute':
        return _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnValue.notExecuted', {
          defaultMessage: 'not executed'
        });
      case 'skip':
        return _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnValue.throttled', {
          defaultMessage: 'throttled'
        });
      default:
        return '';
    }
  };
  const getTableData = () => {
    const actions = watch.watch && watch.watch.actions;
    if (executeResults && actions) {
      const actionStatuses = executeResults.watchStatus && executeResults.watchStatus.actionStatuses;
      return Object.keys(actions).map(actionKey => {
        var _executeResults$detai, _executeResults$detai2, _executeResults$detai3;
        const actionStatus = actionStatuses.find(status => status.id === actionKey);
        const isConditionMet = (_executeResults$detai = executeResults.details) === null || _executeResults$detai === void 0 ? void 0 : (_executeResults$detai2 = _executeResults$detai.result) === null || _executeResults$detai2 === void 0 ? void 0 : _executeResults$detai2.condition.met;
        return {
          actionId: actionKey,
          actionType: (0, _watch_edit_actions.getTypeFromAction)(actions[actionKey]),
          actionMode: actionModes[actionKey],
          actionState: actionStatus && actionStatus.state,
          actionReason: actionStatus && actionStatus.lastExecutionReason,
          actionStatus: isConditionMet && ((_executeResults$detai3 = executeResults.details.result.actions.find(action => action.id === actionKey)) === null || _executeResults$detai3 === void 0 ? void 0 : _executeResults$detai3.status) || conditionNotMetActionStatus(actionModes[actionKey])
        };
      });
    }
    return [];
  };
  const actionsTableData = getTableData();
  const columns = [{
    field: 'actionId',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.actionColumnLabel', {
      defaultMessage: 'ID'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'actionType',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.typeColumnLabel', {
      defaultMessage: 'Type'
    }),
    truncateText: true
  }, {
    field: 'actionMode',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.modeColumnLabel', {
      defaultMessage: 'Mode'
    })
  }, {
    field: 'actionState',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.stateColumnLabel', {
      defaultMessage: 'State'
    }),
    dataType: 'string',
    render: (actionState, _item) => /*#__PURE__*/_react.default.createElement(_components.ActionStateBadge, {
      state: actionState
    })
  }, {
    field: 'actionReason',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.reasonColumnLabel', {
      defaultMessage: 'Reason'
    })
  }, {
    field: 'actionStatus',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.table.statusColumnLabel', {
      defaultMessage: 'Status'
    })
  }];
  const flyoutTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "simulateResultsFlyOutTitle",
    "data-test-subj": "simulateResultsFlyoutTitle"
  }, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.title', {
    defaultMessage: 'Simulation results'
  })));
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      onClose: () => {
        onCloseFlyout();
      },
      "aria-labelledby": "simulateResultsFlyOutTitle"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, flyoutTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_components.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchEdit.simulateResults.errorTitle",
        defaultMessage: "Cannot simulate watch"
      }),
      error: error
    })));
  }
  if (!executeResults) {
    return null;
  }
  const {
    details
  } = executeResults;
  const conditionMetStatus = (details === null || details === void 0 ? void 0 : (_details$result = details.result) === null || _details$result === void 0 ? void 0 : _details$result.condition.met) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "green",
    type: "check",
    "data-test-subj": "conditionMetStatus"
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.simulateResults.conditionMetStatus",
    defaultMessage: "Condition met"
  })) || /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "cross",
    "data-test-subj": "conditionNotMetStatus"
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.sections.watchEdit.simulateResults.conditionNotMetStatus",
    defaultMessage: "Condition not met"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => {
      onCloseFlyout();
    },
    "data-test-subj": "simulateResultsFlyout",
    "aria-labelledby": "simulateResultsFlyOutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, flyoutTitle, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), conditionMetStatus), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, actionsTableData && actionsTableData.length > 0 && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.actionsSectionTitle', {
    defaultMessage: 'Actions'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: actionsTableData,
    "data-test-subj": "simulateResultsTable"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.watcher.sections.watchEdit.simulateResults.simulationOutputSectionTitle', {
    defaultMessage: 'Simulation output'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json"
  }, JSON.stringify(details, null, 2))));
};
exports.SimulateWatchResultsFlyout = SimulateWatchResultsFlyout;