"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseWatch = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _get_search_value = require("../../lib/get_search_value");
var _lodash = require("lodash");
var _action = require("../action");
var _watch_status = require("../watch_status");
var _watch_errors = require("../watch_errors");
var _create_action_id = require("./lib/create_action_id");
var _check_action_id_collision = require("./lib/check_action_id_collision");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BaseWatch {
  /**
   * BaseWatch model constructor
   *
   * @param {object} props An object used to instantiate a watch instance
   * @param {string} props.id Id of the watch
   * @param {string} props.name Optional name for the watch
   * @param {object} props.watch Watch definition
   * @param {object} props.watchStatus WatchStatus definition
   * @param {array} props.actions Action definitions
   */
  constructor(_props = {}) {
    var _this$watchStatus$isA;
    (0, _defineProperty2.default)(this, "updateWatchStatus", watchStatus => {
      this.watchStatus = watchStatus;
    });
    (0, _defineProperty2.default)(this, "createAction", (type, defaults) => {
      const ActionTypes = _action.Action.getActionTypes();
      const ActionType = ActionTypes[type];
      if (!Boolean(ActionType)) {
        throw new Error(_i18n.i18n.translate('xpack.watcher.models.baseWatch.createUnknownActionTypeErrorMessage', {
          defaultMessage: 'Attempted to create unknown action type {type}.',
          values: {
            type
          }
        }));
      }
      const id = (0, _create_action_id.createActionId)(this.actions, type);
      const props = {
        id,
        type,
        ...defaults
      };
      const action = new ActionType(props);
      this.addAction(action);
    });
    (0, _defineProperty2.default)(this, "addAction", action => {
      if ((0, _check_action_id_collision.checkActionIdCollision)(this.actions, action)) {
        action.id = (0, _create_action_id.createActionId)(this.actions, action.type);
      }
      this.actions.push(action);
    });
    (0, _defineProperty2.default)(this, "deleteAction", action => {
      (0, _lodash.remove)(this.actions, action);
    });
    (0, _defineProperty2.default)(this, "resetActions", () => {
      this.actions = [];
    });
    (0, _defineProperty2.default)(this, "isEqualTo", otherWatch => {
      // We need to create a POJO copies because isEqual would return false
      // because of property getters
      const cleanWatch = {
        ...this
      };
      const cleanOtherWatch = {
        ...otherWatch
      };
      return (0, _lodash.isEqual)(cleanWatch, cleanOtherWatch);
    });
    this.id = (0, _lodash.get)(_props, 'id');
    this.type = (0, _lodash.get)(_props, 'type');
    this.isNew = (0, _lodash.get)(_props, 'isNew', true);
    this.name = (0, _lodash.get)(_props, 'name');
    this.isSystemWatch = Boolean((0, _lodash.get)(_props, 'isSystemWatch'));
    this.watchStatus = _watch_status.WatchStatus.fromUpstreamJson((0, _lodash.get)(_props, 'watchStatus'));
    this.watchErrors = _watch_errors.WatchErrors.fromUpstreamJson((0, _lodash.get)(_props, 'watchErrors'));
    this.isActive = (_this$watchStatus$isA = this.watchStatus.isActive) !== null && _this$watchStatus$isA !== void 0 ? _this$watchStatus$isA : true;
    const actions = (0, _lodash.get)(_props, 'actions', []);
    this.actions = actions.map(_action.Action.fromUpstreamJson);
  }
  get displayName() {
    if (this.name) {
      return this.name;
    } else {
      return this.id;
    }
  }
  get searchValue() {
    return (0, _get_search_value.getSearchValue)(this, ['id', 'name']);
  }
  get typeName() {
    return this.constructor.typeName;
  }
  get iconClass() {
    return this.constructor.iconClass;
  }
  get selectMessage() {
    return this.constructor.selectMessage;
  }
  get selectSortOrder() {
    return this.constructor.selectSortOrder;
  }
  get upstreamJson() {
    return {
      id: this.id,
      name: this.name,
      type: this.type,
      isNew: this.isNew,
      isActive: this.isActive,
      actions: (0, _lodash.map)(this.actions, action => action.upstreamJson)
    };
  }
}
exports.BaseWatch = BaseWatch;
(0, _defineProperty2.default)(BaseWatch, "typeName", _i18n.i18n.translate('xpack.watcher.models.baseWatch.typeName', {
  defaultMessage: 'Watch'
}));
(0, _defineProperty2.default)(BaseWatch, "iconClass", '');
(0, _defineProperty2.default)(BaseWatch, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.baseWatch.selectMessageText', {
  defaultMessage: 'Set up a new watch.'
}));
(0, _defineProperty2.default)(BaseWatch, "isCreatable", true);
(0, _defineProperty2.default)(BaseWatch, "selectSortOrder", 0);