"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionStatus = void 0;
var _lodash = require("lodash");
var _get_moment = require("../../../../common/lib/get_moment");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ActionStatus {
  constructor(props = {}) {
    this.id = (0, _lodash.get)(props, 'id');
    this.state = (0, _lodash.get)(props, 'state');
    this.isAckable = (0, _lodash.get)(props, 'isAckable');
    this.lastAcknowledged = (0, _get_moment.getMoment)((0, _lodash.get)(props, 'lastAcknowledged'));
    this.lastThrottled = (0, _get_moment.getMoment)((0, _lodash.get)(props, 'lastThrottled'));
    this.lastExecution = (0, _get_moment.getMoment)((0, _lodash.get)(props, 'lastExecution'));
    this.isLastExecutionSuccessful = (0, _lodash.get)(props, 'isLastExecutionSuccessful');
    this.lastExecutionReason = (0, _lodash.get)(props, 'lastExecutionReason');
    this.lastSuccessfulExecution = (0, _get_moment.getMoment)((0, _lodash.get)(props, 'lastSuccessfulExecution'));
    if (this.lastAcknowledged) {
      this.lastAcknowledgedHumanized = this.lastAcknowledged.fromNow();
    }
    if (this.lastExecution) {
      this.lastExecutionHumanized = this.lastExecution.fromNow();
    }
    if (this.lastThrottled) {
      this.lastThrottledHumanized = this.lastThrottled.fromNow();
    }
  }
  static fromUpstreamJson(upstreamActionStatus) {
    return new ActionStatus(upstreamActionStatus);
  }
}
exports.ActionStatus = ActionStatus;