"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PagerDutyAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _base_action = require("./base_action");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PagerDutyAction extends _base_action.BaseAction {
  constructor(props = {}) {
    super(props);
    const defaultDescription = _i18n.i18n.translate('xpack.watcher.models.pagerdutyAction.defaultDescriptionText', {
      defaultMessage: 'Watch [{context}] has exceeded the threshold',
      values: {
        context: '{{ctx.metadata.name}}'
      }
    });
    this.description = (0, _lodash.get)(props, 'description', props.ignoreDefaults ? null : defaultDescription);
  }
  validate() {
    const errors = {
      description: []
    };
    if (!this.description) {
      errors.description.push(_i18n.i18n.translate('xpack.watcher.watchActions.pagerduty.descriptionIsRequiredValidationMessage', {
        defaultMessage: 'PagerDuty description is required.'
      }));
    }
    return errors;
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    Object.assign(result, {
      description: this.description,
      pagerduty: {
        description: this.description
      }
    });
    return result;
  }
  get simulateMessage() {
    return _i18n.i18n.translate('xpack.watcher.models.pagerDutyAction.simulateMessage', {
      defaultMessage: 'PagerDuty event has been sent.'
    });
  }
  get simulateFailMessage() {
    return _i18n.i18n.translate('xpack.watcher.models.pagerDutyAction.simulateFailMessage', {
      defaultMessage: 'Failed to send PagerDuty event.'
    });
  }
  static fromUpstreamJson(upstreamAction) {
    return new PagerDutyAction(upstreamAction);
  }
}
exports.PagerDutyAction = PagerDutyAction;
(0, _defineProperty2.default)(PagerDutyAction, "typeName", _i18n.i18n.translate('xpack.watcher.models.pagerDutyAction.typeName', {
  defaultMessage: 'PagerDuty'
}));
(0, _defineProperty2.default)(PagerDutyAction, "iconClass", 'apps');
(0, _defineProperty2.default)(PagerDutyAction, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.pagerDutyAction.selectMessageText', {
  defaultMessage: 'Create an event in PagerDuty.'
}));
(0, _defineProperty2.default)(PagerDutyAction, "simulatePrompt", _i18n.i18n.translate('xpack.watcher.models.pagerDutyAction.simulateButtonLabel', {
  defaultMessage: 'Send a PagerDuty event'
}));