"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _base_action = require("./base_action");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndexAction extends _base_action.BaseAction {
  constructor(props = {}) {
    super(props);
    this.index = (0, _lodash.get)(props, 'index');
  }
  validate() {
    const errors = {
      index: []
    };
    return errors;
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    Object.assign(result, {
      index: {
        index: this.index
      }
    });
    return result;
  }
  get simulateMessage() {
    const index = this.index || '';
    return _i18n.i18n.translate('xpack.watcher.models.indexAction.simulateMessage', {
      defaultMessage: 'Index {index} has been indexed.',
      values: {
        index
      }
    });
  }
  get simulateFailMessage() {
    const index = this.index || '';
    return _i18n.i18n.translate('xpack.watcher.models.indexAction.simulateFailMessage', {
      defaultMessage: 'Failed to index {index}.',
      values: {
        index
      }
    });
  }
  static fromUpstreamJson(upstreamAction) {
    return new IndexAction(upstreamAction);
  }
}
exports.IndexAction = IndexAction;
(0, _defineProperty2.default)(IndexAction, "typeName", _i18n.i18n.translate('xpack.watcher.models.indexAction.typeName', {
  defaultMessage: 'Index'
}));
(0, _defineProperty2.default)(IndexAction, "iconClass", 'indexOpen');
(0, _defineProperty2.default)(IndexAction, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.indexAction.selectMessageText', {
  defaultMessage: 'Index data into Elasticsearch.'
}));
(0, _defineProperty2.default)(IndexAction, "simulatePrompt", _i18n.i18n.translate('xpack.watcher.models.indexAction.simulateButtonLabel', {
  defaultMessage: 'Index data'
}));