"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNoItemsMessage = exports.getCustomColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getBadge = item => {
  if (item.stage === 'beta') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      className: "visListingTable__betaIcon",
      label: "B",
      title: _i18n.i18n.translate('visualizations.listing.betaTitle', {
        defaultMessage: 'Beta'
      }),
      tooltipContent: _i18n.i18n.translate('visualizations.listing.betaTooltip', {
        defaultMessage: 'This visualization is in beta and is subject to change. The design and code is less mature than official GA ' + 'features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA ' + 'features'
      })
    });
  } else if (item.stage === 'experimental') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      className: "visListingTable__experimentalIcon",
      label: "E",
      title: _i18n.i18n.translate('visualizations.listing.experimentalTitle', {
        defaultMessage: 'Technical preview'
      }),
      tooltipContent: _i18n.i18n.translate('visualizations.listing.experimentalTooltip', {
        defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
      })
    });
  }
};
const renderItemTypeIcon = item => {
  let icon;
  if (item.image) {
    icon = /*#__PURE__*/_react.default.createElement("img", {
      className: "visListingTable__typeImage",
      "aria-hidden": "true",
      alt: "",
      src: item.image
    });
  } else {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "visListingTable__typeIcon",
      "aria-hidden": "true",
      type: item.icon || 'empty',
      size: "m"
    });
  }
  return icon;
};
const getCustomColumn = () => {
  return {
    field: 'typeTitle',
    name: _i18n.i18n.translate('visualizations.listing.table.typeColumnName', {
      defaultMessage: 'Type'
    }),
    sortable: true,
    width: '150px',
    render: (field, record) => !record.error ? /*#__PURE__*/_react.default.createElement("span", null, renderItemTypeIcon(record), record.typeTitle, getBadge(record)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: "warning",
      color: "warning"
    }, record.error)
  };
};
exports.getCustomColumn = getCustomColumn;
const getNoItemsMessage = createItem => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "visualizeApp",
  title: /*#__PURE__*/_react.default.createElement("h1", {
    id: "visualizeListingHeading",
    "data-test-subj": "emptyListPrompt"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.listing.createNew.title",
    defaultMessage: "Create your first visualization"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.listing.createNew.description",
    defaultMessage: "You can create different visualizations based on your data."
  })),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: createItem,
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "newItemButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.listing.createNew.createButtonLabel",
    defaultMessage: "Create new visualization"
  }))
});
exports.getNoItemsMessage = getNoItemsMessage;