"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVisSchemas = void 0;
var _common = require("@kbn/data-plugin/common");
var _public = require("@kbn/data-plugin/public");
var _common2 = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  isDateHistogramBucketAggConfig
} = _public.search.aggs;
const SUPPORTED_AGGREGATIONS = [...Object.values(_common.METRIC_TYPES), ...Object.values(_common.BUCKET_TYPES), _common.SHARD_DELAY_AGG_NAME];
function isSupportedAggType(name) {
  return SUPPORTED_AGGREGATIONS.includes(name);
}
const updateDateHistogramParams = (agg, {
  timeRange,
  timefilter
}) => {
  if (isDateHistogramBucketAggConfig(agg)) {
    agg.params.timeRange = timeRange;
    const bounds = agg.params.timeRange && agg.fieldIsTimeField() ? timefilter.calculateBounds(agg.params.timeRange) : undefined;
    agg.buckets.setBounds(bounds);
    agg.buckets.setInterval(agg.params.interval);
  }
  return agg;
};
const createSchemaConfig = (agg, accessor, params) => {
  const aggType = agg.type.name;
  if (!isSupportedAggType(aggType)) {
    throw new Error(`Unsupported agg type: ${aggType}`);
  }
  const updatedAgg = updateDateHistogramParams(agg, params);
  return {
    ...(0, _common2.convertToSchemaConfig)(updatedAgg),
    accessor
  };
};
const getVisSchemas = (vis, params) => {
  let cnt = 0;
  const schemas = {
    metric: []
  };
  if (!vis.data.aggs) {
    return schemas;
  }
  const responseAggs = vis.data.aggs.getResponseAggs().filter(agg => agg.enabled);
  const isHierarchical = vis.isHierarchical();
  const metrics = responseAggs.filter(agg => agg.type.type === 'metrics');
  responseAggs.forEach(agg => {
    let skipMetrics = false;
    let schemaName = agg.schema;
    if (!schemaName) {
      if (agg.type.name === 'geo_centroid') {
        schemaName = 'geo_centroid';
      } else {
        cnt++;
        return;
      }
    }
    if (schemaName === 'split') {
      // TODO: We should check if there's a better way then casting to `any` here
      schemaName = `split_${vis.params.row ? 'row' : 'column'}`;
      skipMetrics = responseAggs.length - metrics.length > 1;
    }
    if (!schemas[schemaName]) {
      schemas[schemaName] = [];
    }
    if (!isHierarchical || agg.type.type !== 'metrics') {
      schemas[schemaName].push(createSchemaConfig(agg, cnt++, params));
    }
    if (isHierarchical && (agg.type.type !== 'metrics' || metrics.length === responseAggs.length)) {
      metrics.forEach(metric => {
        const schemaConfig = createSchemaConfig(metric, cnt++, params);
        if (!skipMetrics) {
          schemas.metric.push(schemaConfig);
        }
      });
    }
  });
  return schemas;
};
exports.getVisSchemas = getVisSchemas;