"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVisEmbeddableFromObject = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _services = require("../services");
var _saved_visualize_utils = require("../utils/saved_visualize_utils");
var _visualize_embeddable_async = require("./visualize_embeddable_async");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createVisEmbeddableFromObject = deps => async (vis, input, attributeService, parent) => {
  try {
    var _getCapabilities$dash, _getCapabilities$visu;
    const visId = vis.id;
    const editPath = visId ? (0, _saved_visualize_utils.urlFor)(visId) : '#/edit_by_value';
    const editUrl = visId ? (0, _services.getHttp)().basePath.prepend(`/app/visualize${(0, _saved_visualize_utils.urlFor)(visId)}`) : '';
    let indexPatterns = [];
    if (vis.type.getUsedIndexPattern) {
      try {
        indexPatterns = await vis.type.getUsedIndexPattern(vis.params);
      } catch (e) {
        // nothing to be here
      }
    } else if (vis.data.indexPattern) {
      indexPatterns = [vis.data.indexPattern];
    }
    const capabilities = {
      visualizeSave: Boolean((0, _services.getCapabilities)().visualize.save),
      dashboardSave: Boolean((_getCapabilities$dash = (0, _services.getCapabilities)().dashboard) === null || _getCapabilities$dash === void 0 ? void 0 : _getCapabilities$dash.showWriteControls),
      visualizeOpen: Boolean((_getCapabilities$visu = (0, _services.getCapabilities)().visualize) === null || _getCapabilities$visu === void 0 ? void 0 : _getCapabilities$visu.show)
    };
    return (0, _visualize_embeddable_async.createVisualizeEmbeddableAsync)((0, _services.getTimeFilter)(), {
      vis,
      indexPatterns,
      editPath,
      editUrl,
      deps,
      capabilities
    }, input, attributeService, parent);
  } catch (e) {
    console.error(e); // eslint-disable-line no-console
    return new _public.ErrorEmbeddable(e, input, parent);
  }
};
exports.createVisEmbeddableFromObject = createVisEmbeddableFromObject;