"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visTypesDefinitions = void 0;
var _area = require("./area");
var _line = require("./line");
var _histogram = require("./histogram");
var _horizontal_bar = require("./horizontal_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const visTypesDefinitions = [_area.areaVisTypeDefinition, _line.lineVisTypeDefinition, _histogram.histogramVisTypeDefinition, _horizontal_bar.horizontalBarVisTypeDefinition].map(defenition => {
  return {
    ...defenition,
    navigateToLens: async (vis, timefilter) => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
      return vis ? convertToLens(vis, timefilter) : null;
    },
    getExpressionVariables: async (vis, timeFilter) => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
      return {
        canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertToLens(vis, timeFilter) : null)
      };
    }
  };
});
exports.visTypesDefinitions = visTypesDefinitions;