"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineOptions = LineOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _collections = require("../../../collections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const interpolationModes = (0, _collections.getInterpolationModes)();
function LineOptions({
  chart,
  setChart
}) {
  const setLineWidth = (0, _react.useCallback)((paramName, value) => {
    setChart(paramName, value === '' ? undefined : value);
  }, [setChart]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.showLineLabel', {
      defaultMessage: 'Show line'
    }),
    paramName: "drawLinesBetweenPoints",
    value: chart.drawLinesBetweenPoints,
    setValue: setChart
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    disabled: !chart.drawLinesBetweenPoints,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.lineModeLabel', {
      defaultMessage: 'Line mode'
    }),
    options: interpolationModes,
    paramName: "interpolate",
    value: chart.interpolate,
    setValue: setChart
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.NumberInputOption, {
    disabled: !chart.drawLinesBetweenPoints,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.lineWidthLabel', {
      defaultMessage: 'Line width'
    }),
    paramName: "lineWidth",
    step: 0.5,
    min: 0,
    value: chart.lineWidth,
    setValue: setLineWidth
  }))));
}