"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vislibVisName = exports.createVisTypeVislibVisFn = void 0;
var _i18n = require("@kbn/i18n");
var _response_handler = require("./vislib/response_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-ignore

const vislibVisName = 'vislib_vis';
exports.vislibVisName = vislibVisName;
const createVisTypeVislibVisFn = () => ({
  name: vislibVisName,
  type: 'render',
  inputTypes: ['datatable'],
  help: _i18n.i18n.translate('visTypeVislib.functions.vislib.help', {
    defaultMessage: 'Vislib visualization'
  }),
  args: {
    type: {
      types: ['string'],
      default: '""',
      help: 'vislib vis type'
    },
    visConfig: {
      types: ['string'],
      default: '"{}"',
      help: 'vislib vis config'
    }
  },
  fn(context, args, handlers) {
    var _handlers$inspectorAd;
    const visType = args.type;
    const visConfig = JSON.parse(args.visConfig);
    const visData = (0, _response_handler.vislibSeriesResponseHandler)(context, visConfig.dimensions);
    if (handlers !== null && handlers !== void 0 && (_handlers$inspectorAd = handlers.inspectorAdapters) !== null && _handlers$inspectorAd !== void 0 && _handlers$inspectorAd.tables) {
      handlers.inspectorAdapters.tables.logDatatable('default', context);
    }
    return {
      type: 'render',
      as: vislibVisName,
      value: {
        visData,
        visConfig,
        visType
      }
    };
  }
});
exports.createVisTypeVislibVisFn = createVisTypeVislibVisFn;