"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/expressions-plugin/public");
var _public3 = require("@kbn/data-plugin/public");
var _vis_type_vislib_vis_fn = require("./vis_type_vislib_vis_fn");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const toExpressionAst = async (vis, params) => {
  var _vis$data$aggs$getRes, _vis$data$aggs;
  const schemas = (0, _public.getVisSchemas)(vis, params);
  const dimensions = {
    x: schemas.segment ? schemas.segment[0] : null,
    y: schemas.metric,
    z: schemas.radius,
    width: schemas.width,
    series: schemas.group,
    splitRow: schemas.split_row,
    splitColumn: schemas.split_column
  };
  const responseAggs = (_vis$data$aggs$getRes = (_vis$data$aggs = vis.data.aggs) === null || _vis$data$aggs === void 0 ? void 0 : _vis$data$aggs.getResponseAggs()) !== null && _vis$data$aggs$getRes !== void 0 ? _vis$data$aggs$getRes : [];
  if (dimensions.x) {
    const xAgg = responseAggs[dimensions.x.accessor];
    if (xAgg.type.name === _public3.BUCKET_TYPES.DATE_HISTOGRAM) {
      dimensions.x.params.date = true;
      const {
        esUnit,
        esValue
      } = xAgg.buckets.getInterval();
      dimensions.x.params.intervalESUnit = esUnit;
      dimensions.x.params.intervalESValue = esValue;
      dimensions.x.params.interval = _moment.default.duration(esValue, esUnit).asMilliseconds();
      dimensions.x.params.format = xAgg.buckets.getScaledDateFormat();
      dimensions.x.params.bounds = xAgg.buckets.getBounds();
    } else if (xAgg.type.name === _public3.BUCKET_TYPES.HISTOGRAM) {
      const intervalParam = xAgg.type.paramByName('interval');
      const output = {
        params: {}
      };
      await intervalParam.modifyAggConfigOnSearchRequestStart(xAgg, vis.data.searchSource, {
        abortSignal: params.abortSignal
      });
      intervalParam.write(xAgg, output);
      dimensions.x.params.interval = output.params.interval;
    }
  }
  const visConfig = {
    ...vis.params
  };
  (dimensions.y || []).forEach(yDimension => {
    var _visConfig$gauge;
    const yAgg = responseAggs.filter(({
      enabled
    }) => enabled)[yDimension.accessor];
    const seriesParam = (visConfig.seriesParams || []).find(param => param.data.id === yAgg.id);
    if (seriesParam) {
      const usedValueAxis = (visConfig.valueAxes || []).find(valueAxis => valueAxis.id === seriesParam.valueAxis);
      if ((usedValueAxis === null || usedValueAxis === void 0 ? void 0 : usedValueAxis.scale.mode) === 'percentage') {
        yDimension.format = {
          id: 'percent'
        };
      }
    }
    if ((visConfig === null || visConfig === void 0 ? void 0 : (_visConfig$gauge = visConfig.gauge) === null || _visConfig$gauge === void 0 ? void 0 : _visConfig$gauge.percentageMode) === true) {
      var _visConfig$gauge2;
      yDimension.format = {
        id: 'percent',
        params: {
          pattern: visConfig === null || visConfig === void 0 ? void 0 : (_visConfig$gauge2 = visConfig.gauge) === null || _visConfig$gauge2 === void 0 ? void 0 : _visConfig$gauge2.percentageFormatPattern
        }
      };
    }
  });
  const visTypeVislib = (0, _public2.buildExpressionFunction)(_vis_type_vislib_vis_fn.vislibVisName, {
    type: vis.type.name,
    visConfig: JSON.stringify({
      ...visConfig,
      dimensions
    })
  });
  const ast = (0, _public2.buildExpression)([visTypeVislib]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;