"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfoMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hjson = require("hjson");
var _experimental_map_vis_info = require("./experimental_map_vis_info");
var _deprecated_interval_info = require("./deprecated_interval_info");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const parseSpec = spec => {
  if (spec) {
    try {
      return (0, _hjson.parse)(spec, {
        legacyRoot: false,
        keepWsc: true
      });
    } catch (e) {
      // spec is invalid
    }
  }
};
const InfoMessage = ({
  spec
}) => {
  const vegaSpec = (0, _react.useMemo)(() => parseSpec(spec), [spec]);
  if (!vegaSpec) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _experimental_map_vis_info.shouldShowMapLayerInfo)(vegaSpec) && /*#__PURE__*/_react.default.createElement(_experimental_map_vis_info.ExperimentalMapLayerInfo, null), (0, _deprecated_interval_info.shouldShowDeprecatedHistogramIntervalInfo)(vegaSpec) && /*#__PURE__*/_react.default.createElement(_deprecated_interval_info.DeprecatedHistogramIntervalInfo, null));
};
const getInfoMessage = vis => /*#__PURE__*/_react.default.createElement(InfoMessage, {
  spec: vis.params.spec
});
exports.getInfoMessage = getInfoMessage;