"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldShowDeprecatedHistogramIntervalInfo = exports.DeprecatedHistogramIntervalInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DeprecatedHistogramIntervalInfo = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  className: "hide-for-sharing",
  "data-test-subj": "deprecatedHistogramIntervalInfo",
  size: "s",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeVega.deprecatedHistogramIntervalInfo.message",
    defaultMessage: "Combined 'interval' field has been deprecated in favor of two new, explicit fields: 'calendar_interval' and 'fixed_interval'. {dateHistogramDoc}",
    values: {
      dateHistogramDoc: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "popout",
        href: (0, _services.getDocLinks)().links.aggs.date_histogram,
        target: "_blank"
      })
    }
  }),
  iconType: "help"
});
exports.DeprecatedHistogramIntervalInfo = DeprecatedHistogramIntervalInfo;
const shouldShowDeprecatedHistogramIntervalInfo = spec => {
  const data = Array.isArray(spec.data) ? spec === null || spec === void 0 ? void 0 : spec.data : [spec.data];
  return data.some((dataItem = {}) => {
    var _dataItem$url$body$ag, _dataItem$url, _dataItem$url$body;
    const aggs = (_dataItem$url$body$ag = (_dataItem$url = dataItem.url) === null || _dataItem$url === void 0 ? void 0 : (_dataItem$url$body = _dataItem$url.body) === null || _dataItem$url$body === void 0 ? void 0 : _dataItem$url$body.aggs) !== null && _dataItem$url$body$ag !== void 0 ? _dataItem$url$body$ag : {};
    return Object.keys(aggs).some(key => {
      var _aggs$key;
      const dateHistogram = ((_aggs$key = aggs[key]) === null || _aggs$key === void 0 ? void 0 : _aggs$key[_public.BUCKET_TYPES.DATE_HISTOGRAM]) || {};
      return 'interval' in dateHistogram && typeof dateHistogram.interval !== 'object';
    });
  });
};
exports.shouldShowDeprecatedHistogramIntervalInfo = shouldShowDeprecatedHistogramIntervalInfo;