"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeseriesVisRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactDom = require("react-dom");
var _analytics = require("@kbn/analytics");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _services = require("./services");
var _enums = require("../common/enums");
var _vis_data_utils = require("../common/vis_data_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const TimeseriesVisualization = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./application/components/timeseries_visualization'))));
const checkIfDataExists = (visData, model) => {
  if ('type' in visData) {
    var _visData$model$id;
    const data = (0, _vis_data_utils.isVisTableData)(visData) ? visData.series : visData === null || visData === void 0 ? void 0 : (_visData$model$id = visData[model.id]) === null || _visData$model$id === void 0 ? void 0 : _visData$model$id.series;
    return Boolean(data === null || data === void 0 ? void 0 : data.length);
  }
  return false;
};

/** @internal **/
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};
const getTimeseriesVisRenderer = ({
  uiSettings,
  theme
}) => ({
  name: 'timeseries_vis',
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const {
      visParams: model,
      visData,
      syncColors,
      syncTooltips,
      syncCursor,
      canNavigateToLens
    } = config;
    const showNoResult = !checkIfDataExists(visData, model);
    const renderComplete = () => {
      const usageCollection = (0, _services.getUsageCollectionStart)();
      const containerType = extractContainerType(handlers.getExecutionContext());
      const visualizationType = 'tsvb';
      if (usageCollection && containerType) {
        const counterEvents = [`render_${visualizationType}_${model.type}`, model.use_kibana_indexes === false ? `render_${visualizationType}_index_pattern_string` : undefined, model.time_range_mode === _enums.TIME_RANGE_DATA_MODES.LAST_VALUE ? `render_${visualizationType}_last_value` : undefined, canNavigateToLens ? `render_${visualizationType}_convertable` : undefined].filter(Boolean);
        usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, counterEvents);
      }
      handlers.done();
    };
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_public.VisualizationContainer, {
      "data-test-subj": "timeseriesVis",
      handlers: handlers,
      renderComplete: renderComplete,
      showNoResult: showNoResult,
      error: (0, _lodash.get)(visData, [model.id, 'error'])
    }, /*#__PURE__*/_react.default.createElement(TimeseriesVisualization
    // it is mandatory to bind uiSettings because of "this" usage inside "get" method
    , {
      getConfig: uiSettings.get.bind(uiSettings),
      handlers: handlers,
      model: model,
      visData: visData,
      syncColors: syncColors,
      syncTooltips: syncTooltips,
      syncCursor: syncCursor,
      uiState: handlers.uiState,
      initialRender: renderComplete
    })))), domNode);
  }
});
exports.getTimeseriesVisRenderer = getTimeseriesVisRenderer;