"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToCumulativeSumColumns = void 0;
var _public = require("@kbn/data-plugin/public");
var _metrics = require("../metrics");
var _formula = require("./formula");
var _parent_pipeline = require("./parent_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertToCumulativeSumColumns = ({
  series,
  metrics,
  dataView
}, reducedTimeRange) => {
  var _metric$field$split, _metric$field;
  const metric = metrics[metrics.length - 1];

  //  percentile and percentile_rank value is derived from the field Id. It has the format xxx-xxx-xxx-xxx[percentile]
  const [fieldId, meta] = (_metric$field$split = metric === null || metric === void 0 ? void 0 : (_metric$field = metric.field) === null || _metric$field === void 0 ? void 0 : _metric$field.split('[')) !== null && _metric$field$split !== void 0 ? _metric$field$split : [];
  const subFunctionMetric = metrics.find(({
    id
  }) => id === fieldId);
  if (!subFunctionMetric || subFunctionMetric.type === 'static') {
    return null;
  }
  const pipelineAgg = _metrics.SUPPORTED_METRICS[subFunctionMetric.type];
  if (!pipelineAgg) {
    return null;
  }
  let formula;
  // lens supports cumulative sum for count and sum as quick function
  // and everything else as formula
  if (subFunctionMetric.type !== 'count' && pipelineAgg.name !== 'sum') {
    const metaValue = Number(meta === null || meta === void 0 ? void 0 : meta.replace(']', ''));
    formula = (0, _metrics.getPipelineSeriesFormula)(metric, metrics, subFunctionMetric, {
      metaValue,
      reducedTimeRange,
      timeShift: series.offset_time
    });
    if (!formula) {
      return null;
    }
    return (0, _formula.createFormulaColumn)(formula, {
      series,
      metric,
      dataView
    });
  } else {
    const agg = _metrics.SUPPORTED_METRICS[_public.METRIC_TYPES.CUMULATIVE_SUM];
    return (0, _parent_pipeline.computeParentPipelineColumns)(agg.name, {
      series,
      metric,
      dataView
    }, subFunctionMetric, pipelineAgg, {
      reducedTimeRange
    });
  }
};
exports.convertToCumulativeSumColumns = convertToCumulativeSumColumns;